/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.VersaoCTe;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.centraldocsproprios.DTOCentralDocsPropriosCTe;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCteImpl
extends DaoGenericEntityImpl<Cte, Long> {
    public List<Cte> getCtesParaEnviarStratumKrona(int nrMaxRegistrosPorVez) {
        Criteria crit = this.criteria();
        crit.createAlias("modeloFiscalCte", "m");
        crit.createAlias("m.tipoServicoCte", "t");
        crit.createAlias("cteInfo", "c");
        crit.createAlias("tipoCte", "i");
        crit.add((Criterion)Restrictions.eq((String)"statusStratum", (Object)0));
        crit.add((Criterion)Restrictions.eq((String)"t.codigo", (Object)0));
        crit.add((Criterion)Restrictions.eq((String)"c.status", (Object)100));
        crit.add((Criterion)Restrictions.eq((String)"enviarCteStratum", (Object)1));
        crit.add((Criterion)Restrictions.eq((String)"i.codigo", (Object)0));
        crit.addOrder(Order.asc((String)"identificador"));
        crit.setMaxResults(nrMaxRegistrosPorVez);
        return crit.list();
    }

    public List<Cte> getCtesParaEnviarStratumKrona() {
        Criteria crit = this.criteria();
        crit.createAlias("modeloFiscalCte", "m");
        crit.createAlias("m.tipoServicoCte", "t");
        crit.createAlias("cteInfo", "c");
        crit.createAlias("tipoCte", "i");
        crit.add((Criterion)Restrictions.eq((String)"statusStratum", (Object)0));
        crit.add((Criterion)Restrictions.eq((String)"t.codigo", (Object)0));
        crit.add((Criterion)Restrictions.eq((String)"c.status", (Object)100));
        crit.add((Criterion)Restrictions.eq((String)"enviarCteStratum", (Object)1));
        crit.add((Criterion)Restrictions.eq((String)"i.codigo", (Object)0));
        crit.addOrder(Order.asc((String)"identificador"));
        return crit.list();
    }

    public Cte pesquisarCteNumeroSerieEmpresa(String serie, Long numero, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.eq((String)"serie", (Object)serie));
        crit.add((Criterion)Restrictions.eq((String)"numero", (Object)numero));
        crit.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        return (Cte)crit.uniqueResult();
    }

    public Cte pesquisarCteChaveAcessoEmpresa(String chaveAcesso, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.eq((String)"chaveCte", (Object)chaveAcesso));
        crit.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        return (Cte)crit.uniqueResult();
    }

    public List<Cte> pesquisarCteChaveNotaNfe(String chaveNFeCTe) {
        org.hibernate.query.Query q = this.query("SELECT DISTINCT c FROM Cte c INNER JOIN c.cteNfe n INNER JOIN c.cteInfo i WHERE n.chaveNFe = :chaveNFeCTe AND i.status = :status");
        q.setString("chaveNFeCTe", chaveNFeCTe);
        q.setShort("status", (short)100);
        return this.toList((Query)q);
    }

    public List<DTOCentralDocsPropriosCTe> getCtes(Integer regsPerPage, Integer page, GrupoEmpresa grupoEmpresa, Pessoa pessoa, Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarNumero, Long numero, Short filtrarChave, String chave) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = aux.join((From)jEmpresa, "empresaDados");
        Join jEmpresaPessoa = aux.join((From)jEmpresa, "pessoa");
        Join jEmpresaPessoaComp = aux.join((From)jEmpresaPessoa, "complemento");
        Join jUnidadeFatCliente = aux.join("clienteTomador");
        Join jCliente = aux.join((From)jUnidadeFatCliente, "cliente");
        Join jClientePessoa = aux.join((From)jCliente, "pessoa");
        Join jClientePessoaComp = aux.join((From)jClientePessoa, "complemento");
        Join jtotais = aux.join("cteVlrImpostos");
        Join jinfo = aux.join("cteInfo");
        aux.equal((From)jEmpresaDados, "grupoEmpresa", grupoEmpresa);
        aux.equal((From)jCliente, "pessoa", pessoa);
        LinkedList status = new LinkedList();
        EnumConstNFeStatus.getStatusFinalList().forEach(i -> status.add(i.getValue().shortValue()));
        aux.inNumber((From)jinfo, "status", status);
        if (ToolMethods.isAffirmative((Number)filtrarChave)) {
            aux.equal("chaveNFE", regsPerPage);
        }
        if (ToolMethods.isAffirmative((Number)filtrarData)) {
            aux.between("dataEmissao", dataInicial, (Comparable)ToolDate.getLastDateOnDay((Date)dataFinal));
        }
        if (ToolMethods.isAffirmative((Number)filtrarNumero)) {
            aux.equal("numero", numero);
        }
        aux.setMaxResults(regsPerPage);
        aux.setFirstResult(page * page);
        aux.select(AuxCriteriaBuilder.pair("identificador", "F_ID_NOTA_PROPRIA"), AuxCriteriaBuilder.pair("numero", "F_NUMERO"), AuxCriteriaBuilder.pair("serie", "F_SERIE"), AuxCriteriaBuilder.pair("dataEmissao", "F_DATA_EMISSAO"), AuxCriteriaBuilder.pair("chaveCte", "F_CHAVE"), AuxCriteriaBuilder.pair((From)jinfo, "status", "F_STATUS"), AuxCriteriaBuilder.pair((From)jinfo, "motivo", "F_STATUS_STR"), AuxCriteriaBuilder.pair((From)jtotais, "vrPrestacao", "F_VALOR"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nome", "F_EMITENTE"), AuxCriteriaBuilder.pair((From)jEmpresaPessoa, "nomeFantasia", "F_EMITENTE_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jEmpresaPessoaComp, "cnpj", "F_CNPJ_EMITENTE"), AuxCriteriaBuilder.pair((From)jClientePessoa, "nome", "F_DESTINATARIO"), AuxCriteriaBuilder.pair((From)jClientePessoa, "nomeFantasia", "F_DEST_NOME_FANTASIA"), AuxCriteriaBuilder.pair((From)jClientePessoaComp, "cnpj", "F_CNPJ_DESTINATARIO"));
        List<Map<String, Object>> res = aux.getResultMap();
        LinkedList<DTOCentralDocsPropriosCTe> ret = new LinkedList<DTOCentralDocsPropriosCTe>();
        for (Map<String, Object> map : res) {
            DTOCentralDocsPropriosCTe d = new DTOCentralDocsPropriosCTe();
            d.setIdentificador((Long)map.get("F_ID_NOTA_PROPRIA"));
            d.setNumeroDoc((Number)map.get("F_NUMERO"));
            d.setSerieDoc((String)map.get("F_SERIE"));
            d.setDataEmissao((Date)map.get("F_DATA_EMISSAO"));
            d.setChave((String)map.get("F_CHAVE"));
            d.setValor((Double)map.get("F_VALOR"));
            d.setEmitente((String)map.get("F_EMITENTE"));
            d.setCnpjEmitente((String)map.get("F_CNPJ_EMITENTE"));
            d.setEmitenteNomeFantasia((String)map.get("F_EMITENTE_NOME_FANTASIA"));
            d.setCnpjTomador((String)map.get("F_CNPJ_DESTINATARIO"));
            d.setTomador((String)map.get("F_DESTINATARIO"));
            d.setTomadorNomeFantasia((String)map.get("F_DEST_NOME_FANTASIA"));
            d.setStatusSefaz((Short)map.get("F_STATUS"));
            d.setStatusSefazStr((String)map.get("F_STATUS_STR"));
            ret.add(d);
        }
        return ret;
    }

    public VersaoCTe getVersaoEmissao(Long idNota) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idNota);
        aux.select("versaoCte");
        return (VersaoCTe)aux.getUniqueResult();
    }

    public String getChave(Long idNota) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idNota);
        aux.select("chaveCte");
        return (String)aux.getUniqueResult();
    }
}

