/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.DeParaFornecedor;
import com.touchcomp.basementor.model.vo.DeParaFornecedorItem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoDeParaFornecedorImpl
extends DaoGenericEntityImpl<DeParaFornecedor, Long> {
    public DeParaFornecedor findDeParaFornecedor(UnidadeFatFornecedor fornecedor) {
        String query = "select distinct n  from DeParaFornecedor n  where n.fornecedor = :fornecedor";
        Query q = this.query(query);
        q.setEntity("fornecedor", (Object)fornecedor.getFornecedor());
        q.setMaxResults(1);
        return (DeParaFornecedor)q.uniqueResult();
    }

    public List<DeParaFornecedor> findDeParaFornecedorList(UnidadeFatFornecedor fornecedor) {
        String query = "select distinct n  from DeParaFornecedor n  where n.fornecedor = :fornecedor";
        Query q = this.query(query);
        q.setEntity("fornecedor", (Object)fornecedor.getFornecedor());
        return q.list();
    }

    public DeParaFornecedorItem findDeParaFornecedorItemPorCodigo(UnidadeFatFornecedor fornecedor, String codigo, Empresa empresa, OpcoesCompraSuprimentos opcoesCompra) {
        Object query = "select distinct n  from DeParaFornecedorItem n  where n.deParaFornecedor.fornecedor = :fornecedor and n.codigo = :codigo";
        if (opcoesCompra.getFiltrarDeParaEmpresaFatorConversao().equals((short)1)) {
            query = (String)query + " and (n.itemUnidMedFatorConversao is null or n.empresa = :empresa)";
        }
        Query q = this.query((String)query);
        q.setEntity("fornecedor", (Object)fornecedor.getFornecedor());
        q.setString("codigo", codigo);
        if (opcoesCompra.getFiltrarDeParaEmpresaFatorConversao().equals((short)1)) {
            q.setEntity("empresa", (Object)empresa);
        }
        q.setMaxResults(1);
        return (DeParaFornecedorItem)q.uniqueResult();
    }

    public DeParaFornecedor findDeParaFornEmpresaNatSaida(UnidadeFatFornecedor fornecedor, Empresa empresaDestino, NaturezaOperacao natSaida) {
        Criteria crit = this.criteria();
        crit.createAlias("empresas", "emp");
        crit.createAlias("fornecedores", "forn");
        crit.add(this.eq("emp.empresa", empresaDestino));
        crit.add(this.eq("forn.fornecedor", fornecedor.getFornecedor()));
        crit.add(this.eq("naturezaOperacaoSaida", natSaida));
        crit.setMaxResults(1);
        return (DeParaFornecedor)this.toUnique(crit);
    }

    public DeParaFornecedor findDeParaFornEmpresa(UnidadeFatFornecedor fornecedor, Empresa empresaDestino) {
        Criteria crit = this.criteria();
        crit.createAlias("empresas", "emp");
        crit.createAlias("fornecedores", "forn");
        crit.add(this.eq("emp.empresa", empresaDestino));
        crit.add(this.eq("forn.fornecedor", fornecedor.getFornecedor()));
        crit.setMaxResults(1);
        return (DeParaFornecedor)this.toUnique(crit);
    }

    public DeParaFornecedorItem findDeParaFornEmpresa(DeParaFornecedor dePara, Produto produto) {
        Query q = this.query("select item from DeParaFornecedor d inner join d.itens item where item.produtoSaida=:produto and d=:dePara ");
        q.setEntity("dePara", (Object)dePara);
        q.setEntity("produto", (Object)produto);
        q.setMaxResults(1);
        return (DeParaFornecedorItem)q.uniqueResult();
    }

    public DeParaFornecedorItem findDeParaFornecedorItemPorCodigo(DeParaFornecedor dePara, String codigo) {
        String query = "select distinct n  from DeParaFornecedorItem n  where n.deParaFornecedor = :dePara and n.codigo = :codigo";
        Query q = this.query(query);
        q.setEntity("dePara", (Object)dePara);
        q.setString("codigo", codigo);
        q.setMaxResults(1);
        return (DeParaFornecedorItem)q.uniqueResult();
    }

    public DeParaFornecedorItem findDeParaFornecedorItemPorProdutoSaida(DeParaFornecedor dePara, Produto produtoSaida) {
        String query = "select distinct n  from DeParaFornecedorItem n  where n.deParaFornecedor = :dePara and n.produtoSaida = :produtoSaida";
        Query q = this.query(query);
        q.setEntity("dePara", (Object)dePara);
        q.setEntity("produtoSaida", (Object)produtoSaida);
        q.setMaxResults(1);
        return (DeParaFornecedorItem)q.uniqueResult();
    }

    public List<DeParaFornecedor> findDeParaFornecedorItemPorProdutoSaida(Short filtrarCentroEstoque, Long idCentroEstoque, Short filtrarEmpresa, Long idEmpresa, Short filtrarFornecedor, Long idFornecedor, Short filtrarNaturezaOperacaoEntrada, Long idNaturezaOpEntrada, Short filtrarNaturezaOperacaoSaida, Long idNaturezaOpSaida, Short filtrarProdutoEntrada, Long idProdutoEntrada, Short filtrarProdutoSaida, Long idProdutoSaida) {
        String query = "select DISTINCT\nd as DE_PARA\nfrom DeParaFornecedor d\n\tleft join d.itens id\n\t\tleft join id.produtoEntrada pe\n\t\tleft join id.produtoSaida ps\n\tleft join d.fornecedores fd\n\t\tleft join fd.fornecedor f\n\tleft join d.empresas ed\n\t\tleft join ed.empresa e\n\tleft join d.centroEstoques ced\n\t\tleft join ced.centroEstoque ce\n\tleft join d.naturezaOperacao noEnt\n\tleft join d.naturezaOperacaoSaida noSai\nwhere (:filtrarCentroEstoque <> 1 or ce.identificador = :idCentroEstoque)\nand (:filtrarEmpresa <> 1 or e.identificador = :idEmpresa)\nand (:filtrarFornecedor <> 1 or e.identificador = :idFornecedor)\nand (:filtrarNaturezaOperacaoEntrada <> 1 or noEnt.identificador = :idNaturezaOpEntrada)\nand (:filtrarNaturezaOperacaoSaida <> 1 or noSai.identificador = :idNaturezaOpSaida)\nand (:filtrarProdutoEntrada <> 1 or pe.identificador = :idProdutoEntrada)\nand (:filtrarProdutoSaida <> 1 or ps.identificador = :idProdutoSaida)";
        Query q = this.query(query);
        q.setShort("filtrarCentroEstoque", filtrarCentroEstoque.shortValue());
        q.setLong("idCentroEstoque", idCentroEstoque.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setShort("filtrarFornecedor", filtrarFornecedor.shortValue());
        q.setLong("idFornecedor", idFornecedor.longValue());
        q.setShort("filtrarNaturezaOperacaoEntrada", filtrarNaturezaOperacaoEntrada.shortValue());
        q.setLong("idNaturezaOpEntrada", idNaturezaOpEntrada.longValue());
        q.setShort("filtrarNaturezaOperacaoSaida", filtrarNaturezaOperacaoSaida.shortValue());
        q.setLong("idNaturezaOpSaida", idNaturezaOpSaida.longValue());
        q.setShort("filtrarProdutoEntrada", filtrarProdutoEntrada.shortValue());
        q.setLong("idProdutoEntrada", idProdutoEntrada.longValue());
        q.setShort("filtrarProdutoSaida", filtrarProdutoSaida.shortValue());
        q.setLong("idProdutoSaida", idProdutoSaida.longValue());
        return q.list();
    }
}

