/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.EmbalagemProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEmbalagemProducaoImpl
extends DaoGenericEntityImpl<EmbalagemProducao, Long> {
    public EmbalagemProducao getEmbalagemProducaoByCodigoBarras(String codigoBarras, Empresa empresa) {
        CriteriaBuilder builder = this.criteriaBuilder(EmbalagemProducao.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromEmbalagemProducao = crit.from(EmbalagemProducao.class);
        crit.select((Selection)fromEmbalagemProducao);
        exps.add(builder.equal((Expression)fromEmbalagemProducao.get("codigoBarras"), (Object)codigoBarras));
        exps.add(builder.equal((Expression)fromEmbalagemProducao.get("empresa"), (Object)empresa));
        crit.where(exps.toArray(new Predicate[0]));
        return (EmbalagemProducao)this.getEntityManager().createQuery(crit).getSingleResult();
    }

    public List<EmbalagemProducao> pesquisarEmbalagemProduzidasPorDataCentroCustoEmpresa(Date data, CentroCusto centroCusto, Empresa empresa) {
        Integer filtrarCentroCusto = EnumConstantsMentorSimNao.SIM.getValueInt();
        if (centroCusto == null) {
            filtrarCentroCusto = EnumConstantsMentorSimNao.NAO.getValueInt();
        }
        return this.query("SELECT e FROM EmbalagemProducao e WHERE CAST(e.dataAbertura AS date) = :data AND (:filtrarCentroCusto = 0 OR e.centroCusto = :centroCusto) AND e.empresa = :empresa").setParameter("data", (Object)data).setParameter("filtrarCentroCusto", (Object)filtrarCentroCusto).setParameter("centroCusto", (Object)centroCusto).setParameter("empresa", (Object)empresa).list();
    }
}

