/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorclientwebservices.ponto.model.empresaintegracao.DTOPontoEmpresaIntegracao;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.DTOComboObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEmpresaImpl
extends DaoGenericEntityImpl<Empresa, Long> {
    public Empresa findByCnpj(String cnpj) {
        Criteria c = this.criteria();
        c.createAlias("pessoa", "p");
        c.createAlias("p.complemento", "c");
        return (Empresa)this.toUnique(this.restrictions(c, this.eq("c.cnpj", cnpj)));
    }

    public List<Empresa> get(Long idEmpresaInicial, Long idEmpresaFinal) {
        Criteria c = this.criteria();
        c.add(this.between("identificador", idEmpresaInicial, idEmpresaFinal));
        return this.toList(c);
    }

    public List<Empresa> getEmpresasAtivas() {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("empresaDados", "ed");
        this.order(crit, "identificador");
        return this.toList(this.restrictions(crit, this.eq("p.ativo", (short)1), this.eq("ed.ativo", (short)1)));
    }

    public List<DTOComboObject> getDTOEmpresasAtivas() {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jPessoa = aux.join("pessoa");
        Join jDados = aux.join("empresaDados");
        aux.select("identificador");
        aux.select((From)jPessoa, "nome");
        aux.select((From)jPessoa, "nomeFantasia");
        aux.where(aux.equal((From)jDados, "ativo", (short)1), aux.equal((From)jPessoa, "ativo", (short)1));
        List data = aux.getResult();
        ArrayList<DTOComboObject> ret = new ArrayList<DTOComboObject>();
        for (Object[] d : data) {
            String nome = (String)d[1];
            String nomeFantasia = (String)d[2];
            DTOComboObject dto = new DTOComboObject();
            dto.setId((Long)d[0]);
            if (ToolMethods.isStrWithData((String)nomeFantasia)) {
                dto.setTitle(nomeFantasia);
            } else {
                dto.setTitle(nome);
            }
            ret.add(dto);
        }
        Collections.sort(ret, (o1, o2) -> o1.getTitle().compareTo(o2.getTitle()));
        return ret;
    }

    public Empresa findEmpresaPorEmpresaDados(Long idEmpresaDados) {
        String query = "select\ne as empresa\nfrom Empresa e\n   inner join e.empresaDados ed\nwhere ed.identificador = :idEmpresaDados";
        Query q = this.query(query);
        q.setLong("idEmpresaDados", idEmpresaDados.longValue());
        return (Empresa)q.uniqueResult();
    }

    @Override
    public Empresa get(Pessoa pessoa) {
        return (Empresa)this.toUnique(this.restrictions(this.eq("pessoa", pessoa)));
    }

    public List<DTOPontoEmpresaIntegracao> findEmpresasPontoEletronico() {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jPessoa = aux.join("pessoa");
        Join jComplemento = jPessoa.join("complemento");
        Join jEndereco = jPessoa.join("endereco");
        Join jCidade = jEndereco.join("cidade");
        Join jUf = jCidade.join("uf");
        aux.select("identificador");
        aux.select((From)jPessoa, "nome");
        aux.select((From)jComplemento, "fone1");
        aux.select((From)jComplemento, "emailPrincipal");
        aux.select((From)jComplemento, "cnpj");
        aux.select((From)jEndereco, "cep");
        aux.select((From)jEndereco, "logradouro");
        aux.select((From)jEndereco, "bairro");
        aux.select((From)jCidade, "descricao");
        aux.select((From)jUf, "sigla");
        aux.select((From)jPessoa, "nomeFantasia");
        List data = aux.getResult();
        LinkedList<DTOPontoEmpresaIntegracao> result = new LinkedList<DTOPontoEmpresaIntegracao>();
        for (Object[] obj : data) {
            DTOPontoEmpresaIntegracao dto = new DTOPontoEmpresaIntegracao();
            dto.setIdEmpresa((Long)obj[0]);
            dto.setNome((String)obj[1]);
            dto.setTelefone((String)obj[2]);
            dto.setEmail((String)obj[3]);
            dto.setCnpj((String)obj[4]);
            dto.setCep((String)obj[5]);
            dto.setEndereco((String)obj[6]);
            dto.setBairro((String)obj[7]);
            dto.setCidade((String)obj[8]);
            dto.setUf((String)obj[9]);
            dto.setNomeFantasia((String)obj[10]);
            result.add(dto);
        }
        return result;
    }

    public Empresa getEager(Long idEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("identificador", idEmpresa);
        Empresa emp = (Empresa)aux.getUniqueResult();
        if (emp == null) {
            return null;
        }
        emp.getPessoa().getComplemento();
        emp.getPessoa().getEndereco().getCidade().getUf().getPais();
        emp.getEmpresaDados().getGrupoEmpresa();
        return emp;
    }
}

