/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.BloqueioGeral;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EncerramentoContabil;
import com.touchcomp.basementor.model.vo.EncerramentoContabilItem;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.SaldoContaAno;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.impl.DaoBloqueioGeralImpl;
import com.touchcomp.basementorservice.dao.impl.DaoLoteContabilImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEncerramentoContabilImpl
extends DaoGenericEntityImpl<EncerramentoContabil, Long> {
    @Autowired
    DaoBloqueioGeralImpl daoBloqueio;
    @Autowired
    DaoLoteContabilImpl daoLoteContabil;

    public EncerramentoContabil getVerificarExisteEncerramentoContabilNasDatas(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        org.hibernate.query.Query q = this.query("SELECT e FROM EncerramentoContabil e WHERE (:dataInicial BETWEEN e.dataInicial AND e.dataFinal OR :dataFinal BETWEEN e.dataInicial AND e.dataFinal) AND e.grupoEmpresa = :grupoEmpresa");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        return (EncerramentoContabil)this.toUnique((Query)q);
    }

    public List<EncerramentoContabil> getVerificarExisteEncerramentosContabilNasDatas(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        org.hibernate.query.Query q = this.query("SELECT e FROM EncerramentoContabil e WHERE (:dataInicial BETWEEN e.dataInicial AND e.dataFinal OR :dataFinal BETWEEN e.dataInicial AND e.dataFinal) AND e.grupoEmpresa = :grupoEmpresa");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        return this.toList((Query)q);
    }

    public EncerramentoContabil getVerificarExisteEncerramentoContabilDeDataFinal(Date dataFinal, GrupoEmpresa grupoEmpresa) {
        org.hibernate.query.Query q = this.query("SELECT e FROM EncerramentoContabil e WHERE (:dataFinal = e.dataFinal) AND e.grupoEmpresa = :grupoEmpresa");
        q.setDate("dataFinal", dataFinal);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        return (EncerramentoContabil)this.toUnique((Query)q);
    }

    @Override
    public boolean delete(EncerramentoContabil entity) {
        entity = (EncerramentoContabil)this.get(entity.getIdentificador());
        LinkedList lotes = new LinkedList();
        entity.getItensEncerramentoContabil().forEach(i -> {
            lotes.add(i.getLoteLancLucroPrejuizo());
            lotes.add(i.getLoteLancRes());
            i.setLoteLancLucroPrejuizo(null);
            i.setLoteLancRes(null);
        });
        BloqueioGeral bl = entity.getBloqueioGeral();
        entity.setBloqueioGeral(null);
        entity = this.saveOrUpdate(entity);
        this.daoBloqueio.delete(bl);
        this.daoBloqueio.getSession().flush();
        for (Object item : lotes) {
            this.daoLoteContabil.deleteLoteQuery((LoteContabil)item);
        }
        CriteriaBuilder criteriaBuilder = this.getSession().getCriteriaBuilder();
        for (EncerramentoContabilItem encerramentoContabilItem : entity.getItensEncerramentoContabil()) {
            CriteriaDelete querySaldo = criteriaBuilder.createCriteriaDelete(SaldoContaAno.class);
            Root rootSaldo = querySaldo.from(SaldoContaAno.class);
            querySaldo.where((Expression)criteriaBuilder.equal((Expression)rootSaldo.get("encerramentoContabilItem"), (Object)encerramentoContabilItem));
            this.getSession().createQuery(querySaldo).executeUpdate();
        }
        CriteriaDelete query = criteriaBuilder.createCriteriaDelete(EncerramentoContabilItem.class);
        Root root = query.from(EncerramentoContabilItem.class);
        query.where((Expression)criteriaBuilder.equal((Expression)root.get("encerramentoContabil"), (Object)entity));
        this.getSession().createQuery(query).executeUpdate();
        CriteriaDelete queryEnc = criteriaBuilder.createCriteriaDelete(EncerramentoContabil.class);
        Root rootEnc = queryEnc.from(EncerramentoContabil.class);
        queryEnc.where((Expression)criteriaBuilder.equal((Expression)rootEnc, (Object)entity));
        this.getSession().createQuery(queryEnc).executeUpdate();
        return true;
    }

    public EncerramentoContabil getVerificarExisteEncerramentoContabilNaDataEmpresaBloquearPeriodo(Date dataFinal, Empresa empresa, Short bloquearPeriodo) {
        org.hibernate.query.Query q = this.query("SELECT e FROM EncerramentoContabil e WHERE e.dataFinal     > :dataFinal AND e.empresa         = :empresa AND e.bloquearPeriodo = :bloquearPeriodo");
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("bloquearPeriodo", bloquearPeriodo.shortValue());
        return (EncerramentoContabil)this.toUnique((Query)q);
    }
}

