/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.smartcomponente.EnumConstSmartComponente;
import com.touchcomp.basementor.constants.enums.tipocoletadadosativo.EnumConstTipoColetaAtivo;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoIOT;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoSensorIOT;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.SmartComponentPref;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEquipColetaDadosAtivoIOTImpl
extends DaoGenericEntityImpl<EquipColetaDadosAtivoIOT, Long> {
    public List<SmartComponentPref> getSmartComponentsProcessamento() {
        Criteria c = this.criteria();
        c.createCriteria("smartComponenteProcArquivo", "pref");
        c.createCriteria("pref.smartComponente", "sma");
        ProjectionList sel = Projections.projectionList();
        sel.add(Projections.distinct((Projection)Projections.property((String)"smartComponenteProcArquivo")));
        c.add(this.eq("sma.tipoComponente", EnumConstSmartComponente.SMART_FACTORY_FILE_READER.getValue()));
        c.setProjection((Projection)sel);
        return c.list();
    }

    public EquipColetaDadosAtivoIOT getByEquipamento(Equipamento equipamentoColeta) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("equipamentoColeta", equipamentoColeta);
        return (EquipColetaDadosAtivoIOT)aux.getUniqueResult();
    }

    public EquipColetaDadosAtivoSensorIOT getSensorEquipamento(Long idEquipamento) {
        AuxCriteriaBuilder aux = this.queryBuilder(EquipColetaDadosAtivoSensorIOT.class);
        Join jEquip = aux.join("equipamento");
        Join jTipo = aux.join("tipoColetaDados");
        aux.equal((From)jEquip, "identificador", idEquipamento);
        aux.equal((From)jTipo, "tipoColeta", EnumConstTipoColetaAtivo.PRODUCAO.getValue());
        return (EquipColetaDadosAtivoSensorIOT)aux.getUniqueResult();
    }
}

