/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.RelacaoEquipamento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.sql.Timestamp;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEquipamentoImpl
extends DaoGenericEntityImpl<Equipamento, Long> {
    public Equipamento getByCodigoAndEmpresa(String codigoEquipamento, String cnpj) {
        Criteria c = this.criteria();
        c.createAlias("empresa", "emp");
        c.createAlias("emp.pessoa", "pes");
        c.createAlias("pes.complemento", "comp");
        return (Equipamento)this.toUnique(this.restrictions(this.eq("codigo", codigoEquipamento), this.eq("comp.cnpj", cnpj), this.eq("ativo", (short)1)));
    }

    public Boolean isSubComponente(Equipamento equipamento) {
        Criteria c = this.criteria(RelacaoEquipamento.class);
        c.createAlias("equipamentoFilho", "ef");
        c.add(this.eq("ef.identificador", equipamento.getIdentificador()));
        if (c.list().size() > 0) {
            return true;
        }
        return false;
    }

    public Timestamp getDataUltimaManutencao(PlanoManutencaoAtivo planoManutencaoAtivo, Equipamento ativo, Empresa empresa, Short opcaoPesquisa) {
        if (planoManutencaoAtivo == null || planoManutencaoAtivo.getIdentificador() == null || ativo == null || empresa == null || opcaoPesquisa == null) {
            return null;
        }
        if (ToolMethods.isEquals((Object)opcaoPesquisa, (Object)EnumConstTipoDataUltimaManutencao.PESQUISAR_POR_DATA_FINALIZACAO.getValue())) {
            Criteria c = this.criteria(Executante.class);
            c.createAlias("fechamentoOrdemServico", "fo");
            c.createAlias("fo.ordemServico", "os");
            c.createAlias("os.planosManutencaoAtivo", "pm");
            ProjectionList p = Projections.projectionList();
            p.add((Projection)Projections.max((String)"dataHoraFinal"));
            c.setProjection((Projection)p);
            c.add(this.eq("pm", planoManutencaoAtivo));
            c.add(this.eq("os.equipamento", ativo));
            c.add(this.eq("os.empresa", empresa));
            c.add(this.eq("fo.osFechada", EnumConstantsMentorSimNao.SIM.getValue()));
            List result = c.list();
            return result.isEmpty() ? null : result.get(0);
        }
        Criteria c = this.criteria(FechamentoOrdemServico.class);
        c.createAlias("ordemServico", "os");
        c.createAlias("os.planosManutencaoAtivo", "pm");
        ProjectionList p = Projections.projectionList();
        p.add((Projection)Projections.max((String)"os.dataProgramada"));
        c.setProjection((Projection)p);
        c.add(this.eq("pm", planoManutencaoAtivo));
        c.add(this.eq("os.equipamento", ativo));
        c.add(this.eq("os.empresa", empresa));
        c.add(this.eq("osFechada", EnumConstantsMentorSimNao.SIM.getValue()));
        List result = c.list();
        return result.isEmpty() ? null : result.get(0);
    }
}

