/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEsocCadastroEstabelcimentoImpl
extends DaoGenericEntityImpl<EsocCadastroEstabelcimento, Long> {
    public List<EsocCadastroEstabelcimento> getEsocCadastroEstabelecimentoEmpresa(Long idEmpresa) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(EsocCadastroEstabelcimento.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root root = crit.from(EsocCadastroEstabelcimento.class);
            Join jEmpresa = root.join("empresa", JoinType.INNER);
            crit.select((Selection)root);
            exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)idEmpresa));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception e) {
            return null;
        }
    }

    public EsocCadastroEstabelcimento getPorCnpj(String cnpj) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(EsocCadastroEstabelcimento.class);
            CriteriaQuery crit = builder.createQuery(EsocCadastroEstabelcimento.class);
            Root root = crit.from(EsocCadastroEstabelcimento.class);
            Join jEmpresa = root.join("empresa", JoinType.INNER);
            Join jPessoa = jEmpresa.join("pessoa", JoinType.INNER);
            Join jComplemento = jPessoa.join("complemento", JoinType.INNER);
            crit.select((Selection)root);
            crit.where((Expression)builder.equal((Expression)jComplemento.get("cnpj"), (Object)cnpj));
            return (EsocCadastroEstabelcimento)this.getEntityManager().createQuery(crit).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public EsocCadastroEstabelcimento getPorCei(String codCei) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(EsocCadastroEstabelcimento.class);
            CriteriaQuery crit = builder.createQuery(EsocCadastroEstabelcimento.class);
            Root root = crit.from(EsocCadastroEstabelcimento.class);
            Join jEmpresa = root.join("empresa", JoinType.INNER);
            Join jPessoa = jEmpresa.join("pessoa", JoinType.INNER);
            Join jComplemento = jPessoa.join("complemento", JoinType.INNER);
            crit.select((Selection)root);
            crit.where((Expression)builder.equal((Expression)jComplemento.get("codCei"), (Object)codCei));
            return (EsocCadastroEstabelcimento)this.getEntityManager().createQuery(crit).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }
}

