/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocValoresIrrfColaborador;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IdentificacaoAmbienteEsocial;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEsocEventoImpl
extends DaoGenericEntityImpl<EsocEvento, Long> {
    public List<EsocEvento> findEventosGeradosNaoEnviados(Empresa logedEmpresa, TipoEventoEsocial tp, IdentificacaoAmbienteEsocial ambiente) {
        Criteria crit = this.criteria();
        crit.createAlias("preEvento", "p");
        if (ambiente.getCodigo().equals("1")) {
            return this.toList(this.restrictions(crit, this.eq("p.empresa", logedEmpresa), this.isNull("nrRecibo"), this.eq("p.tipoEventoEsocial", tp), this.notEqual("status", 101L), this.eq("p.eventoProdRestritaProducao", EnumConstEventoProducao.EVENTO_PRODUCAO.getValue())));
        }
        return this.toList(this.restrictions(crit, this.eq("p.empresa", logedEmpresa), this.isNull("nrRecibo"), this.eq("p.tipoEventoEsocial", tp), this.notEqual("status", 101L), this.eq("p.eventoProdRestritaProducao", EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE.getValue())));
    }

    public List<EsocValoresIrrfColaborador> getValoresIrrfEsocial(Date periodoInicial, Date periodoFinal, GrupoEmpresa grupoEmpresa, Short tipo) {
        String hql = " from EsocValoresIrrfColaborador e where  e.periodoApuracao between :periodoInicial and :periodoFinal  and  e.esocEvento.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  e.esocEvento.preEvento.eventoProdRestritaProducao = :tipo  and     not exists (from EsocEvento es             where             es.preEvento.eventoRetificacao = 1             and             es.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa            and             es.preEvento.tipoEventoEsocial = e.esocEvento.preEvento.tipoEventoEsocial             and             es.preEvento.eventoProdRestritaProducao = : tipo            and             es.preEvento.numeroReciboRetificado = e.esocEvento.nrRecibo)";
        Query q = this.query(hql);
        q.setDate("periodoInicial", periodoInicial);
        q.setDate("periodoFinal", periodoFinal);
        q.setShort("tipo", tipo.shortValue());
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        return q.list();
    }

    public List<Object[]> findEventosEnviados(Empresa empresa, Date periodo) {
        Criteria c = this.criteria();
        c.createAlias("preEvento", "preEvt");
        c.createAlias("preEvt.tipoEventoEsocial", "tipoEvt");
        c.createAlias("preEvt.recisao", "recisao", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("preEvt.convocacao", "convocacao", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("preEvt.emissaoAviso", "emissaoAviso", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("preEvt.colaborador", "colaborador", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("preEvt.admissaoPreLiminar", "preLiminar", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("preEvt.reaberturaEventos", "reabertura", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("preEvt.fechamentoEventos", "fec", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("preEvt.esocS1200", "inss", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("inss.esocFechamentoFolha", "periodo", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("preEvt.esocS1210", "irrf", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("irrf.esocFechamento", "periodoF", JoinType.LEFT_OUTER_JOIN);
        c.add(this.eq("status", EnumConstESocialStatus.STATUS_SUCESSO.getValue()));
        c.add(this.eq("preEvt.empresa", empresa));
        c.add(this.eq("preEvt.eventoProdRestritaProducao", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.isNull("preEvt.eventoPosterior"));
        c.add(this.or(this.and(this.isNotNull("preEvt.empresaRH"), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.estabelecimento"), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.tipoCalculo"), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.lotacaoTrbutaria"), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.funcao"), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.infoHorario"), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.esocS1200"), this.between("periodo.periodoApuracao", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.esocS1210"), this.between("periodoF.periodoApuracao", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.reaberturaEventos"), this.between("reabertura.periodo", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.fechamentoEventos"), this.between("fec.periodoReferencia", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.admissaoPreLiminar"), this.between("preLiminar.dataAdmissao", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.colaborador"), this.eq("tipoEvt.identificador", EnumConstTipoEventoESocial.CADASTRAMENTO_INICIAL_VINC_ADMISSAO_INGRESSO_TRAB.getValue()), this.between("colaborador.dataAdmissao", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.colaborador"), this.eq("tipoEvt.identificador", EnumConstTipoEventoESocial.ALTERACAO_DADOS_CADASTRAIS_COLABORADOR.getValue()), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.colaborador"), this.eq("tipoEvt.identificador", EnumConstTipoEventoESocial.ALTERACAO_CONTRATO_TRABALHO.getValue()), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.eq("tipoEvt.identificador", EnumConstTipoEventoESocial.AFASTAMENTO_TEMPORARIO.getValue()), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.colaborador"), this.eq("tipoEvt.identificador", EnumConstTipoEventoESocial.TRABALHADOR_SEM_VINC_EMPREGO_INICIO.getValue()), this.between("colaborador.dataAdmissao", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.emissaoAviso"), this.between("emissaoAviso.dataEmissaoAviso", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.convocacao"), this.between("convocacao.dataInicio", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.recisao"), this.between("recisao.dataAfastamento", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo))), this.and(this.isNotNull("preEvt.exclusaoEventos"), this.between("preEvt.dataInicioVal", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo)))));
        ProjectionList p = Projections.projectionList();
        p.add((Projection)Projections.count((String)"identificador"));
        p.add((Projection)Projections.groupProperty((String)"tipoEvt.identificador"));
        p.add((Projection)Projections.groupProperty((String)"tipoEvt.codigo"));
        p.add((Projection)Projections.groupProperty((String)"tipoEvt.descricao"));
        c.addOrder(Order.asc((String)"tipoEvt.codigo"));
        c.setProjection((Projection)p);
        return c.list();
    }
}

