/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCondicoesAmbientaisTrabalho;
import com.touchcomp.basementor.model.vo.EsocExameToxicologico;
import com.touchcomp.basementor.model.vo.EsocMonitoramentoSaude;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocProcessoTrabalhista;
import com.touchcomp.basementor.model.vo.EsocReaberturaEventos;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.IdentificacaoAmbienteEsocial;
import com.touchcomp.basementor.model.vo.TabelaProcessosEsoc;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEsocPreEventoImpl
extends DaoGenericEntityImpl<EsocPreEvento, Long> {
    public List<EsocPreEvento> findEventosNaoGerados(Empresa empresa, TipoEventoEsocial tp, IdentificacaoAmbienteEsocial ambiente) {
        if (ambiente.getCodigo().equals("1")) {
            return this.toList(this.restrictions(this.criteria(), this.isNull("esocEvento"), this.eq("empresa", empresa), this.eq("tipoEventoEsocial", tp), this.eq("eventoProdRestritaProducao", EnumConstEventoProducao.EVENTO_PRODUCAO.getEnumId())));
        }
        return this.toList(this.restrictions(this.criteria(), this.isNull("esocEvento"), this.eq("empresa", empresa), this.eq("tipoEventoEsocial", tp), this.eq("eventoProdRestritaProducao", EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE.getEnumId())));
    }

    public List<EsocPreEvento> getEventosProcessoTrabalhista(EsocProcessoTrabalhista proc) {
        Criteria c = this.criteria();
        c.createAlias("processoTrabalhista", "proc");
        c.add(this.eq("proc.identificador", proc.getIdentificador()));
        return c.list();
    }

    public List<EsocPreEvento> getEventosCondicoesAmbTrabalho(EsocCondicoesAmbientaisTrabalho vo) {
        Criteria c = this.criteria();
        c.createAlias("condicoes", "cat");
        c.add(this.eq("cat.identificador", vo.getIdentificador()));
        return c.list();
    }

    public List<EsocPreEvento> getEventosMonitoramentoSaude(EsocMonitoramentoSaude vo) {
        Criteria c = this.criteria();
        c.createAlias("monitoramento", "mon");
        c.add(this.eq("mon.identificador", vo.getIdentificador()));
        return c.list();
    }

    public List<EsocPreEvento> getEventosReaberturaEvt(EsocReaberturaEventos vo) {
        Criteria c = this.criteria();
        c.createAlias("reaberturaEventos", "re");
        c.add(this.eq("re.identificador", vo.getIdentificador()));
        return c.list();
    }

    public List<EsocPreEvento> getEventosTabelaProcessos(TabelaProcessosEsoc vo) {
        Criteria c = this.criteria();
        c.createAlias("tabelaProcesso", "tp");
        c.add(this.eq("tp.identificador", vo.getIdentificador()));
        return c.list();
    }

    public void atualizarEventoPosterior(EsocPreEvento e) {
        Query query = this.query("update EsocPreEvento e set e.eventoPosterior = null where e.eventoPosterior = :e");
        query.setParameter("e", (Object)e);
        query.executeUpdate();
    }

    public List<EsocPreEvento> getEventosExameToxicologico(EsocExameToxicologico vo) {
        Criteria c = this.criteria();
        c.createAlias("exameToxicologico", "e");
        c.add(this.eq("e.identificador", vo.getIdentificador()));
        return c.list();
    }

    public List<EsocPreEvento> findEventosNaoEnviados(GrupoEmpresa grupo, TipoEventoEsocial tipoEventoEsocial) {
        Criteria c = this.criteria();
        c.createAlias("esocEvento", "evt");
        c.createAlias("empresa", "emp");
        c.createAlias("emp.empresaDados", "empDados");
        if (tipoEventoEsocial != null) {
            c.add(this.eq("tipoEventoEsocial", tipoEventoEsocial));
        }
        c.add(this.or(this.isNull("esocEvento"), this.and(this.notEqual("evt.status", EnumConstESocialStatus.STATUS_SUCESSO.getValue()), this.notEqual("evt.status", EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue()))));
        c.add(this.eq("empDados.grupoEmpresa", grupo));
        return c.list();
    }

    public List<EsocPreEvento> getMovimentacaoTrabalhista(Long idColaborador) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(EsocPreEvento.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromEsocPreEvento = crit.from(EsocPreEvento.class);
            Join jEsocEvento = fromEsocPreEvento.join("esocEvento", JoinType.INNER);
            Join jAfastamentoColaborador = fromEsocPreEvento.join("afastamentoColaborador", JoinType.LEFT);
            Join jRecisao = fromEsocPreEvento.join("recisao", JoinType.LEFT);
            Join jEmissaoAviso = fromEsocPreEvento.join("emissaoAviso", JoinType.LEFT);
            Join jFeriasColaborador = fromEsocPreEvento.join("feriasColaborador", JoinType.LEFT);
            Join jPeriodoAqFeriasColab = jFeriasColaborador.join("periodoAqFeriasColab", JoinType.LEFT);
            Join jColaboradorPeriodoAq = jPeriodoAqFeriasColab.join("colaborador", JoinType.LEFT);
            Join jTransferenciaColaborador = fromEsocPreEvento.join("transferenciaColaborador", JoinType.LEFT);
            Join jConvocacao = fromEsocPreEvento.join("convocacao", JoinType.LEFT);
            crit.select((Selection)fromEsocPreEvento);
            exps.add(builder.equal((Expression)fromEsocPreEvento.get("eventoProdRestritaProducao"), (Object)EnumConstEventoProducao.EVENTO_PRODUCAO.getEnumId()));
            exps.add(builder.isNotNull((Expression)fromEsocPreEvento.get("esocEvento")));
            Predicate status = builder.or((Expression)builder.equal((Expression)jEsocEvento.get("status"), (Object)EnumConstESocialStatus.STATUS_SUCESSO.getEnumId()), (Expression)builder.equal((Expression)jEsocEvento.get("status"), (Object)EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getEnumId()));
            exps.add(status);
            Predicate colaboradorCondition = builder.or(new Predicate[]{builder.equal((Expression)jColaboradorPeriodoAq, (Object)idColaborador), builder.equal((Expression)jAfastamentoColaborador.get("colaborador"), (Object)idColaborador), builder.equal((Expression)jRecisao.get("colaborador"), (Object)idColaborador), builder.equal((Expression)jEmissaoAviso.get("colaborador"), (Object)idColaborador), builder.equal((Expression)fromEsocPreEvento.get("colaborador"), (Object)idColaborador), builder.equal((Expression)jTransferenciaColaborador.get("colaborador"), (Object)idColaborador), builder.equal((Expression)jConvocacao.get("colaborador"), (Object)idColaborador)});
            exps.add(colaboradorCondition);
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception e) {
            return new ArrayList<EsocPreEvento>();
        }
    }
}

