/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstRegistroESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocValores5011;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEsocValores5011Impl
extends DaoGenericEntityImpl<EsocValores5011, Long> {
    public List<EsocValores5011> findValores(GrupoEmpresa grupo, Date periodo) {
        CriteriaBuilder builder = this.criteriaBuilder(EsocValores5011.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(EsocValores5011.class);
        Join jEsocEvento = root.join("esocEvento", JoinType.INNER);
        exps.add(builder.between((Expression)root.get("periodoApuracao"), (Comparable)ToolDate.getDataInicial((Date)periodo), (Comparable)ToolDate.getDataFinal((Date)periodo)));
        Subquery subquery = crit.subquery(EsocEvento.class);
        Root fromEsocEvento = subquery.from(EsocEvento.class);
        LinkedList<Predicate> expsSub = new LinkedList<Predicate>();
        Join jPreEvento = fromEsocEvento.join("preEvento", JoinType.INNER);
        Join jEmpresa = jPreEvento.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        Join jTipoEvtESocial = jPreEvento.join("tipoEventoEsocial", JoinType.INNER);
        expsSub.add(builder.equal((Expression)fromEsocEvento.get("identificador"), (Expression)jEsocEvento.get("identificador")));
        expsSub.add(builder.isNull((Expression)jPreEvento.get("eventoPosterior")));
        expsSub.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        expsSub.add(builder.equal((Expression)jTipoEvtESocial.get("identificador"), (Object)EnumConstTipoEventoESocial.FECHAMENTO_EVENTOS_PERIODICOS.getValue()));
        expsSub.add(builder.equal((Expression)jPreEvento.get("eventoProdRestritaProducao"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        subquery.where(expsSub.toArray(new Predicate[0]));
        subquery.groupBy(new Expression[]{fromEsocEvento.get("identificador")});
        subquery.select(builder.max((Expression)fromEsocEvento.get("identificador")));
        exps.add(builder.and(new Predicate[]{jEsocEvento.get("identificador").in((Expression)subquery)}));
        Subquery subqueryEsocVal = crit.subquery(ItemOutrosTitulosFolha.class);
        Root fromItemOutrosTitulosFolha = subqueryEsocVal.from(ItemOutrosTitulosFolha.class);
        Join jEsocValores = fromItemOutrosTitulosFolha.join("esocValores5011", JoinType.INNER);
        subqueryEsocVal.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)jEsocValores.get("identificador"), (Expression)root.get("identificador"))}));
        subqueryEsocVal.select((Expression)fromItemOutrosTitulosFolha);
        exps.add(builder.not((Expression)builder.exists(subqueryEsocVal)));
        crit.select((Selection)root);
        crit.orderBy(new Order[]{builder.desc((Expression)root.get("identificador"))});
        crit.where(exps.toArray(new Predicate[0]));
        ArrayList<EsocValores5011> novaLista = new ArrayList<EsocValores5011>();
        List lista = this.getEntityManager().createQuery(crit).getResultList();
        if (ToolMethods.isWithData((Collection)lista)) {
            novaLista.add((EsocValores5011)lista.get(0));
        }
        return novaLista;
    }

    public List<EsocValores5011> findValoresInssSemGeracaoTitulos(Date dataPagamento, GrupoEmpresa grupoEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(EsocValores5011.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(EsocValores5011.class);
        Join jEsocEvento = root.join("esocEvento", JoinType.INNER);
        Join jEsocPreEvento = jEsocEvento.join("preEvento", JoinType.INNER);
        Join jEmpresa = jEsocPreEvento.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        Join jTipoEventoEsocial = jEsocPreEvento.join("tipoEventoEsocial", JoinType.INNER);
        exps.add(builder.between((Expression)root.get("periodoApuracao"), (Comparable)ToolDate.getDataInicial((Date)dataPagamento), (Comparable)ToolDate.getDataFinal((Date)dataPagamento)));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupoEmpresa));
        exps.add(builder.or((Expression)builder.equal((Expression)jTipoEventoEsocial.get("identificador"), (Object)EnumConstRegistroESocial.REGISTRO_1200.getValue()), (Expression)builder.equal((Expression)jTipoEventoEsocial.get("identificador"), (Object)EnumConstRegistroESocial.REGISTRO_2299.getValue())));
        exps.add(builder.equal((Expression)jEsocPreEvento.get("eventoProdRestritaProducao"), (Object)EnumConstEventoProducao.EVENTO_PRODUCAO.getValue()));
        Subquery subqueryEsocVal = crit.subquery(ItemOutrosTitulosFolha.class);
        Root fromItemOutrosTitulosFolha = subqueryEsocVal.from(ItemOutrosTitulosFolha.class);
        Join jEsocValores = fromItemOutrosTitulosFolha.join("esocValores5011", JoinType.INNER);
        subqueryEsocVal.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)jEsocValores.get("identificador"), (Expression)root.get("identificador"))}));
        subqueryEsocVal.select((Expression)fromItemOutrosTitulosFolha);
        exps.add(builder.not((Expression)builder.exists(subqueryEsocVal)));
        crit.orderBy(new Order[]{builder.desc((Expression)root.get("identificador"))});
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

