/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstTipoEventoESocial;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocValoresInssColaborador;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEsocValoresInssColaboradorImpl
extends DaoGenericEntityImpl<EsocValoresInssColaborador, Long> {
    public List<EsocValoresInssColaborador> findValores(GrupoEmpresa grupo, Date periodo) {
        CriteriaBuilder builder = this.criteriaBuilder(EsocValoresInssColaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(EsocValoresInssColaborador.class);
        Join jEsocEvento = root.join("esocEvento", JoinType.INNER);
        Join jPreEvento = jEsocEvento.join("preEvento", JoinType.INNER);
        Join jTipoEventoESoc = jPreEvento.join("tipoEventoEsocial", JoinType.INNER);
        Join jEmpresa = jPreEvento.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.between((Expression)root.get("periodoApuracao"), (Comparable)ToolDate.getDataInicial((Date)periodo), (Comparable)ToolDate.getDataFinal((Date)periodo)));
        exps.add(builder.or((Expression)builder.equal((Expression)jTipoEventoESoc.get("identificador"), (Object)EnumConstTipoEventoESocial.REMUNERACAO_TRABALHADOR_VINC_REGIME_GERAL_PREV_SOCIAL.getValue()), (Expression)builder.equal((Expression)jTipoEventoESoc.get("identificador"), (Object)EnumConstTipoEventoESocial.DESLIGAMENTO.getValue())));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        exps.add(builder.equal((Expression)jPreEvento.get("eventoProdRestritaProducao"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        Subquery subquery = crit.subquery(EsocEvento.class);
        Root fromEsocEvento = subquery.from(EsocEvento.class);
        LinkedList<Predicate> expsSub = new LinkedList<Predicate>();
        Join jSubPreEvento = fromEsocEvento.join("preEvento", JoinType.INNER);
        Join jSubEmpresa = jSubPreEvento.join("empresa", JoinType.INNER);
        Join jSubEmpresaDados = jSubEmpresa.join("empresaDados", JoinType.INNER);
        Join jTipoEvtESocial = jSubPreEvento.join("tipoEventoEsocial", JoinType.INNER);
        expsSub.add(builder.equal((Expression)jSubPreEvento.get("eventoRetificacao"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        expsSub.add(builder.equal((Expression)jSubEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        expsSub.add(builder.or((Expression)builder.equal((Expression)jTipoEvtESocial.get("identificador"), (Object)EnumConstTipoEventoESocial.REMUNERACAO_TRABALHADOR_VINC_REGIME_GERAL_PREV_SOCIAL.getValue()), (Expression)builder.equal((Expression)jTipoEvtESocial.get("identificador"), (Object)EnumConstTipoEventoESocial.DESLIGAMENTO.getValue())));
        expsSub.add(builder.equal((Expression)jSubPreEvento.get("tipoEventoEsocial"), (Expression)jPreEvento.get("tipoEventoEsocial")));
        expsSub.add(builder.equal((Expression)jSubPreEvento.get("eventoProdRestritaProducao"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        expsSub.add(builder.equal((Expression)jSubPreEvento.get("numeroReciboRetificado"), (Expression)jEsocEvento.get("nrRecibo")));
        subquery.where(expsSub.toArray(new Predicate[0]));
        subquery.groupBy(new Expression[]{fromEsocEvento.get("identificador")});
        subquery.select((Expression)fromEsocEvento);
        exps.add(builder.or((Expression)builder.isNull((Expression)jPreEvento.get("eventoPosterior")), (Expression)builder.not((Expression)builder.exists(subquery))));
        crit.select((Selection)root);
        crit.orderBy(new Order[]{builder.desc((Expression)root.get("totalInssEsocial"))});
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

