/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.esocial.centraleventos.EnumConstTipoBuscaIrrf;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocValoresIrrfColaborador;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEsocValoresIrrfColaboradorImpl
extends DaoGenericEntityImpl<EsocValoresIrrfColaborador, Long> {
    public List<EsocValoresIrrfColaborador> findValores(GrupoEmpresa grupo, Date periodo, EnumConstTipoBuscaIrrf tipoBusca) {
        CriteriaBuilder builder = this.criteriaBuilder(EsocValoresIrrfColaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(EsocValoresIrrfColaborador.class);
        Join jEsocEvento = root.join("esocEvento", JoinType.INNER);
        Join jPPreEvento = jEsocEvento.join("preEvento", JoinType.INNER);
        Join jPEmpresa = jPPreEvento.join("empresa", JoinType.INNER);
        Join jPEmpresaDados = jPEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.between((Expression)root.get("periodoApuracao"), (Comparable)ToolDate.getDataInicial((Date)periodo), (Comparable)ToolDate.getDataFinal((Date)periodo)));
        exps.add(builder.equal((Expression)jPPreEvento.get("eventoProdRestritaProducao"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.equal((Expression)jPEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        if (ToolMethods.isEquals((Object)tipoBusca, (Object)EnumConstTipoBuscaIrrf.IRRF_RETIDO)) {
            exps.add(builder.greaterThan((Expression)root.get("totalInssEsocial"), (Comparable)Double.valueOf(0.0)));
        }
        Subquery subquery = crit.subquery(EsocEvento.class);
        Root fromEsocEvento = subquery.from(EsocEvento.class);
        LinkedList<Predicate> expsSub = new LinkedList<Predicate>();
        Join jPreEvento = fromEsocEvento.join("preEvento", JoinType.INNER);
        Join jEmpresa = jPreEvento.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        expsSub.add(builder.equal((Expression)jPreEvento.get("eventoRetificacao"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        expsSub.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        expsSub.add(builder.equal((Expression)jPreEvento.get("tipoEventoEsocial"), (Expression)jPPreEvento.get("tipoEventoEsocial")));
        expsSub.add(builder.equal((Expression)jPreEvento.get("eventoProdRestritaProducao"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        expsSub.add(builder.equal((Expression)jPreEvento.get("numeroReciboRetificado"), (Expression)jEsocEvento.get("nrRecibo")));
        subquery.where(expsSub.toArray(new Predicate[0]));
        subquery.groupBy(new Expression[]{fromEsocEvento.get("identificador")});
        subquery.select((Expression)fromEsocEvento);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

