/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.filtroanaliseorcamentaria.EnumConstFiltroAnaliseOrcamentaria;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentaria;
import com.touchcomp.basementor.model.vo.PlanejamentoOrcamentario;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.res.DTOEntidadeRes;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEstruturaOrcamentariaImpl
extends DaoGenericEntityImpl<EstruturaOrcamentaria, Long> {
    public List<EstruturaOrcamentaria> getEstruturasTravadas(EnumConstFiltroAnaliseOrcamentaria filtro, Empresa loggedEmpresa) {
        Criterion filtroEmpresa;
        Criteria c = this.criteria();
        Criterion travarEstrurura = this.eq("travarEstrutura", (short)1);
        if (TMethods.isEquals((Object)filtro, (Object)EnumConstFiltroAnaliseOrcamentaria.GRUPO_EMPRESA)) {
            c.createAlias("empresa", "e");
            c.createAlias("e.empresaDados", "d");
            filtroEmpresa = this.eq("d.grupoEmpresa", loggedEmpresa.getEmpresaDados().getGrupoEmpresa());
        } else {
            filtroEmpresa = this.eq("empresa", loggedEmpresa);
        }
        return this.toList(this.restrictions(c, filtroEmpresa, travarEstrurura));
    }

    public List<DTOEntidadeRes> getPlanejamentosVincEstrutura(Long idEstrutura) {
        Query q = this.query("select distinct p from EstruturaOrcamentaria e inner join PlanejamentoOrcamentario p on(p.intervalorControleGer=e.intervaloControleGer) where e.identificador = :id order by p.descricao");
        q.setLong("id", idEstrutura.longValue());
        List aux = q.list();
        LinkedList<DTOEntidadeRes> ret = new LinkedList<DTOEntidadeRes>();
        for (PlanejamentoOrcamentario ii : aux) {
            ret.add(new DTOEntidadeRes(ii.getIdentificador(), ii.getDescricao()));
        }
        return ret;
    }

    public List<DTOEntidadeRes> getPlanejamentosVincEstrutura(Long idEstrutura, Long idUsuario) {
        Query q = this.query("select distinct p from EstruturaOrcamentaria e inner join PlanejamentoOrcamentario p on(p.intervalorControleGer=e.intervaloControleGer) inner join p.pacoteOrcamentario po inner join po.usuario u where e.identificador = :id and u.identificador=:idUser order by p.descricao");
        q.setLong("id", idEstrutura.longValue());
        q.setLong("idUser", idUsuario.longValue());
        List aux = q.list();
        LinkedList<DTOEntidadeRes> ret = new LinkedList<DTOEntidadeRes>();
        for (PlanejamentoOrcamentario ii : aux) {
            ret.add(new DTOEntidadeRes(ii.getIdentificador(), ii.getDescricao()));
        }
        return ret;
    }
}

