/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.EventoComprovanteEntrega;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEventoComprovanteEntregaImpl
extends DaoGenericEntityImpl<EventoComprovanteEntrega, Long> {
    public EventoComprovanteEntrega findByIdMobile(BigInteger idMobile) {
        return (EventoComprovanteEntrega)this.toUnique(this.restrictions(this.eq("idMobile", idMobile)));
    }

    public List<EventoComprovanteEntrega> pesquisarComprovantes(Long idEmpresa, Long idEntregador, Date dataInicial, Date dataFinal, Integer nrNota, String serieNota, String nomeRecebedor, String docRecebedor) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jEmpresa = builder.join("empresa");
        Join jEntregador = builder.join("entregador");
        builder.equal((From)jEmpresa, "identificador", idEmpresa);
        builder.equal((From)jEntregador, "identificador", idEntregador);
        if (TMethods.isNotNull((Object)dataInicial).booleanValue() && TMethods.isNotNull((Object)dataFinal).booleanValue()) {
            builder.between("dataEntrega", dataInicial, (Comparable)dataFinal);
        }
        if (TMethods.isNotNull((Object)nrNota).booleanValue() && nrNota > 0) {
            builder.equal("numeroNota", nrNota);
        }
        if (TMethods.isStrWithData((String)serieNota)) {
            builder.equal("serieNota", serieNota);
        }
        if (TMethods.isStrWithData((String)nomeRecebedor)) {
            builder.or(builder.ilike("nomeRecebedor", nomeRecebedor), builder.ilike("nomeRecebedor", nomeRecebedor.toUpperCase()));
        }
        if (TMethods.isStrWithData((String)docRecebedor)) {
            builder.or(builder.equal("documentoRecebedor", docRecebedor), builder.equal("documentoRecebedor", docRecebedor.toUpperCase()));
        }
        return builder.getResult();
    }
}

