/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstOrigemEventoOSProd;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOColaboradorEvt;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOFaseProdutivaEvt;
import com.touchcomp.basementorservice.service.impl.comunicadoproducao.modelaux.VOProdutosRequisicaoEvt;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEventoOsProdSobEncImpl
extends DaoGenericEntityImpl<EventoOsProdSobEnc, Long> {
    public List<EventoOsProdSobEnc> findEventosOSSOBEnc(Date dataInicial, Date dataFinal, Empresa empresa) {
        Query q = this.query("select distinct e from EventoOsProdSobEnc e inner join e.subdivisaoOSProdSobEnc s inner join s.ordemServicoProdSobEnc o where cast(e.dataFechamento as date) between :dataIn and :dataFim and e.empresa = :empresa");
        q.setParameter("empresa", (Object)empresa);
        q.setParameter("dataIn", (Object)dataInicial);
        q.setParameter("dataFim", (Object)dataFinal);
        return q.list();
    }

    public EventoOsProdSobEnc getEventoAberto(String numeroRegistro, Long idempresa, EnumConstOrigemEventoOSProd origemEvento) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEvtEmp = aux.join("empresa");
        Join jEvtCols = aux.join("colaboradoresEvtProd");
        Join jEvtColsCol = aux.join((From)jEvtCols, "colaborador");
        aux.where(aux.equal((From)jEvtColsCol, "numeroRegistro", numeroRegistro), aux.equal((From)jEvtEmp, "identificador", idempresa), aux.equal("origemEvento", origemEvento.getValue()), aux.isNull("dataFechamento"));
        return (EventoOsProdSobEnc)aux.getUniqueResult();
    }

    public EventoOsProdSobEnc getEventoAberto(Long idempresa, EnumConstOrigemEventoOSProd origemEvento) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEvtEmp = aux.join("empresa");
        aux.where(aux.equal((From)jEvtEmp, "identificador", idempresa), aux.equal("origemEvento", origemEvento.getValue()), aux.isNull("dataFechamento"));
        return (EventoOsProdSobEnc)aux.getUniqueResult();
    }

    public List<EventoOsProdSobEnc> getEventos(OrdemServicoProdSobEnc osSobEnc) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEvtSub = aux.join("subdivisaoOSProdSobEnc");
        aux.where(aux.equal((From)jEvtSub, "ordemServicoProdSobEnc", osSobEnc));
        return aux.getResultEnt();
    }

    public List<VOFaseProdutivaEvt> getEventosVOFase(OrdemServicoProdSobEnc osSobEnc) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEvtFase = aux.join("faseProdutiva");
        Join jEvtSub = aux.join("subdivisaoOSProdSobEnc");
        aux.where(aux.equal((From)jEvtSub, "ordemServicoProdSobEnc", osSobEnc));
        aux.select("dataFechamento", "horaEvento");
        aux.select((From)jEvtFase, "identificador");
        List data = aux.getResult();
        LinkedList<VOFaseProdutivaEvt> ret = new LinkedList<VOFaseProdutivaEvt>();
        for (Object[] object : data) {
            VOFaseProdutivaEvt v = new VOFaseProdutivaEvt();
            v.setDataFechamento((Date)object[0]);
            v.setHoraEvento((Double)object[1]);
            v.setFaseProdutivaIdentificador((Long)object[2]);
            ret.add(v);
        }
        return ret;
    }

    public List<VOColaboradorEvt> getEventosVOColaborador(OrdemServicoProdSobEnc osSobEnc) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEvtColabs = aux.join("colaboradoresEvtProd");
        Join jEvtColab = aux.join((From)jEvtColabs, "colaborador");
        Join jEvtSub = aux.join("subdivisaoOSProdSobEnc");
        aux.where(aux.equal((From)jEvtSub, "ordemServicoProdSobEnc", osSobEnc));
        aux.select("dataFechamento", "horaEvento");
        aux.select((From)jEvtColab, "identificador");
        List data = aux.getResult();
        LinkedList<VOColaboradorEvt> ret = new LinkedList<VOColaboradorEvt>();
        for (Object[] object : data) {
            VOColaboradorEvt v = new VOColaboradorEvt();
            v.setDataFechamento((Date)object[0]);
            v.setHoraEvento((Double)object[1]);
            v.setColaboradorIdentificador((Long)object[2]);
            ret.add(v);
        }
        return ret;
    }

    public List<VOProdutosRequisicaoEvt> getEventosVOProduto(ItemComunicadoProducao itemComunicadoProducao) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEvtItem = aux.join("itemEventoOsProdSobEnc");
        Join jEvtReq = aux.join((From)jEvtItem, "requisicao");
        Join jEvtReqItem = aux.join((From)jEvtReq, "itensRequisicao");
        Join jEvtReqItemCentroEst = aux.join((From)jEvtReqItem, "centroEstoque");
        Join jEvtReqItemGrade = aux.join((From)jEvtReqItem, "gradeItemRequisicao");
        Join jEvtReqItemGradeCor = aux.join((From)jEvtReqItemGrade, "gradeCor");
        Join jEvtItens = aux.join("itemEventoOsProdSobEnc");
        aux.where(aux.equal((From)jEvtItens, "itemComunicadoProducao", itemComunicadoProducao));
        aux.select((From)jEvtReq, "dataRequisicao");
        aux.select((From)jEvtReqItemGradeCor, "identificador");
        aux.select((From)jEvtReqItemCentroEst, "identificador");
        aux.select((From)jEvtReqItemGrade, "quantidade");
        List data = aux.getResult();
        LinkedList<VOProdutosRequisicaoEvt> ret = new LinkedList<VOProdutosRequisicaoEvt>();
        for (Object[] object : data) {
            VOProdutosRequisicaoEvt v = new VOProdutosRequisicaoEvt();
            v.setDataFechamento((Date)object[0]);
            v.setGradeCorIdentificador((Long)object[1]);
            v.setCentroEstoqueIdentificador((Long)object[2]);
            v.setQuantidade((Double)object[3]);
            ret.add(v);
        }
        return ret;
    }
}

