/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.eventoosproducao.EnumConstOrigemEventoOSProd;
import com.touchcomp.basementor.constants.enums.tipoproducao.EnumConstTipoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapEvtProducaoQtd;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapEvtProducaoTipoEvento;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoEventoOsProducaoLinhaProdImpl
extends DaoGenericEntityImpl<EventoOsProducaoLinhaProd, Long> {
    public List<Map<String, Object>> getQuantidadeApontadaEvt(Long idGradeCor, Date dataInicial, Date dataFinal) {
        org.hibernate.query.Query q = this.query("select cel.identificador as ID_CELULA_PRODUTIVA ,sum(g.quantidade) as QUANTIDADE ,sum(e.horaEvento) as TEMPO ,cel.descricao as CELULA ,f.qtdePorHora as QTD_HORA_ROTEIRO ,r.identificador as ID_ROTEIRO_PRODUCAO ,f.descricaoAuxiliar as FASE_PRODUTIVA from EventoOsProducaoLinhaProd e inner join e.faseProdutiva f inner join f.roteiroProducao r inner join f.celulaProdutiva cel inner join e.comunicadoProducao c inner join c.itemComunicadoProducao i inner join i.gradeItemComunicadoProducao g inner join g.gradeCor gc where gc.identificador=:idGrade and e.dataFechamento between :dataInicial and :dataFinal group by cel.identificador, cel.descricao,f.qtdePorHora,r.identificador,f.descricaoAuxiliar ");
        q.setLong("idGrade", idGradeCor.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        r.forEach(map -> {
            Double quantidade = (Double)map.get("QUANTIDADE");
            Double qtdHoraRoteiro = (Double)map.get("QTD_HORA_ROTEIRO");
            Double tempo = (Double)map.get("TEMPO");
            if (tempo > 0.0) {
                map.put("CAPACIDADE_PRODUTIVA", quantidade / tempo);
            }
            map.put("CAPACIDADE_PRODUTIVA_ROTEIRO", qtdHoraRoteiro);
        });
        return r;
    }

    public List<EventoOsProducaoLinhaProd> getEventosPeriodo(Date dataInicial, Date dataFinal, Empresa empresa) {
        org.hibernate.query.Query q = this.query("select e from EventoOsProducaoLinhaProd e  inner join e.subdivisaoOSProd s where cast(e.dataFechamento as date) between :dataInicial and :dataFinal and e.empresa=:empresa order by e.dataFechamento, s.nrOrdem, e.identificador");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        return this.toList((Query)q);
    }

    public List<EventoOsProducaoLinhaProd> pesquisarEventosSubOS(SubdivisaoOSProdLinhaProd subDivisaoOSProd) {
        org.hibernate.query.Query q = this.query("SELECT e FROM EventoOsProducaoLinhaProd e WHERE e.subdivisaoOSProd = :subDivisaoOSProd");
        q.setEntity("subDivisaoOSProd", (Object)subDivisaoOSProd);
        return this.toList((Query)q);
    }

    public EventoOsProducaoLinhaProd getEvtOSByCodSincronizacao(String codSincronizacao, SubdivisaoOSProdLinhaProd sub) {
        Criteria crit = this.criteria(EventoOsProducaoLinhaProd.class);
        crit.setMaxResults(1);
        return (EventoOsProducaoLinhaProd)this.restrictions(crit, this.eq("subdivisaoOSProd", sub), this.eq("codigoSincronizacao", codSincronizacao)).uniqueResult();
    }

    public EventoOsProducaoLinhaProd getEventoAberto(String numeroRegistro, Long idEmpresa, EnumConstOrigemEventoOSProd origem) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEvtCols = aux.join("colaboradoresEvtProd");
        Join jEvtEmp = aux.join("empresa");
        Join jEvtColsCol = aux.join((From)jEvtCols, "colaborador");
        aux.where(aux.equal((From)jEvtColsCol, "numeroRegistro", numeroRegistro), aux.equal((From)jEvtEmp, "identificador", idEmpresa), aux.isNull("dataFechamento"), aux.equal("origemEvento", origem.getValue()));
        return (EventoOsProducaoLinhaProd)aux.getUniqueResult();
    }

    public List<GenericMapValues<GenMapEvtProducaoQtd>> getApontamentosProducaoQtd(short filtrarCelula, Long idCelula, short filtrarEquipamento, Long idEquipamento, short filtrarTipoProducao, EnumConstTipoProducao tipoProducao, Date dataInicial, Date dataFinal, boolean usarQuantidadeRef) {
        AuxCriteriaBuilder aux = this.queryBuilder(EventoOsProducaoLinhaProd.class);
        Join jCelFaseProd = aux.join("faseProdutiva");
        Join jCelProd = jCelFaseProd.join("celulaProdutiva");
        Join jComProducao = aux.join("comunicadoProducao");
        Join jComProducaoitem = jComProducao.join("itemComunicadoProducao");
        Join jComProducaoitemProd = jComProducaoitem.join("produto");
        Join jComProducaoitemProdUn = jComProducaoitemProd.join("unidadeMedida");
        Join jComProducaoTipoProducao = jComProducaoitem.join("tipoProducao");
        Join jEquipsEventos = aux.joinLeft("equipamentos");
        Join jEquipsEventosFaseProd = jEquipsEventos.join("faseProdutivaEquip", JoinType.LEFT);
        Join jEquipsEventosCelProd = jEquipsEventosFaseProd.join("celProdutivaEquip", JoinType.LEFT);
        Join jEquipamento = jEquipsEventosCelProd.join("equipamento", JoinType.LEFT);
        AuxCriteriaBuilder.Pair identificadorSel = new AuxCriteriaBuilder.Pair((From)jComProducaoitemProd, "identificador", GenMapEvtProducaoQtd.ID_PRODUTO.getValue());
        AuxCriteriaBuilder.Pair codAuxProdutoSel = new AuxCriteriaBuilder.Pair((From)jComProducaoitemProd, "codigoAuxiliar", GenMapEvtProducaoQtd.CODIGO_AUX_PRODUTO.getValue());
        AuxCriteriaBuilder.Pair produtoSel = new AuxCriteriaBuilder.Pair((From)jComProducaoitemProd, "nome", GenMapEvtProducaoQtd.PRODUTO.getValue());
        AuxCriteriaBuilder.Pair siglaUnProdSel = new AuxCriteriaBuilder.Pair((From)jComProducaoitemProdUn, "sigla", GenMapEvtProducaoQtd.UN_PRODUTO.getValue());
        AuxCriteriaBuilder.Pair tipoProducaoSel = new AuxCriteriaBuilder.Pair((From)jComProducaoTipoProducao, "tipo", GenMapEvtProducaoQtd.TIPO_PRODUCAO.getValue());
        AuxCriteriaBuilder.Pair dataComSel = new AuxCriteriaBuilder.Pair((From)jComProducao, "dataFinal", GenMapEvtProducaoQtd.DATA.getValue());
        AuxCriteriaBuilder.Pair quantidadeTotalSel = new AuxCriteriaBuilder.Pair((From)jComProducaoitem, "quantidadeTotal", GenMapEvtProducaoQtd.QUANTIDADE_TOTAL.getValue());
        if (usarQuantidadeRef) {
            quantidadeTotalSel = new AuxCriteriaBuilder.Pair((From)jComProducaoitem, "quantidadeTotalRef", GenMapEvtProducaoQtd.QUANTIDADE_TOTAL.getValue());
        }
        AuxCriteriaBuilder.Pair tempoProducaoTotalSel = new AuxCriteriaBuilder.Pair("horaEvento", GenMapEvtProducaoQtd.HORA_PRODUCAO.getValue());
        AuxCriteriaBuilder.Pair tempoProducaoRoteiroTotalSel = new AuxCriteriaBuilder.Pair("horaEventoRoteiro", GenMapEvtProducaoQtd.HORA_PRODUCAO_ROTEIRO.getValue());
        aux.select(identificadorSel, codAuxProdutoSel, produtoSel, siglaUnProdSel, tipoProducaoSel, dataComSel);
        aux.select(aux.getSum(quantidadeTotalSel), aux.getSum(tempoProducaoTotalSel), aux.getSum(tempoProducaoRoteiroTotalSel));
        aux.groupBy(identificadorSel, codAuxProdutoSel, produtoSel, siglaUnProdSel, tipoProducaoSel, dataComSel);
        if (TMethods.isAffirmative((Number)filtrarEquipamento)) {
            aux.equal((From)jEquipamento, "identificador", idEquipamento);
        }
        if (TMethods.isAffirmative((Number)filtrarTipoProducao)) {
            aux.equal((From)jComProducaoTipoProducao, "tipo", tipoProducao.getValue());
        }
        if (TMethods.isAffirmative((Number)filtrarCelula)) {
            aux.equal((From)jCelProd, "identificador", idCelula);
        }
        aux.between((From)jComProducao, "dataFinal", dataInicial, (Comparable)dataFinal);
        List<Map<String, Object>> producoesProdDiaria = aux.getResultMap();
        return this.toGenMapList(producoesProdDiaria, GenMapEvtProducaoQtd.class);
    }

    public List<GenericMapValues<GenMapEvtProducaoQtd>> getApontamentosProducaoProdSubosQtd(short filtrarCelula, Long idCelula, short filtrarEquipamento, Long idEquipamento, short filtrarTipoProducao, EnumConstTipoProducao tipoProducao, Date dataInicial, Date dataFinal, boolean usarQuantidadeRef) {
        AuxCriteriaBuilder aux = this.queryBuilder(EventoOsProducaoLinhaProd.class);
        Join jCelFaseProd = aux.join("faseProdutiva");
        Join jCelProd = jCelFaseProd.join("celulaProdutiva");
        Join jSubOS = aux.join("subdivisaoOSProd");
        Join jSubOSGrade = jSubOS.join("gradeCor");
        Join jSubOSProdGrade = jSubOSGrade.join("produtoGrade");
        Join jSubOSProd = jSubOSProdGrade.join("produto");
        Join jSubOSProdUn = jSubOSProd.join("unidadeMedida");
        Join jComProducao = aux.join("comunicadoProducao");
        Join jComProducaoitem = jComProducao.join("itemComunicadoProducao");
        Join jComProducaoTipoProducao = jComProducaoitem.join("tipoProducao");
        Join jEquipsEventos = aux.joinLeft("equipamentos");
        Join jEquipsEventosFaseProd = jEquipsEventos.join("faseProdutivaEquip", JoinType.LEFT);
        Join jEquipsEventosCelProd = jEquipsEventosFaseProd.join("celProdutivaEquip", JoinType.LEFT);
        Join jEquipamento = jEquipsEventosCelProd.join("equipamento", JoinType.LEFT);
        AuxCriteriaBuilder.Pair identificadorSel = new AuxCriteriaBuilder.Pair((From)jSubOSProd, "identificador", GenMapEvtProducaoQtd.ID_PRODUTO.getValue());
        AuxCriteriaBuilder.Pair codAuxProdutoSel = new AuxCriteriaBuilder.Pair((From)jSubOSProd, "codigoAuxiliar", GenMapEvtProducaoQtd.CODIGO_AUX_PRODUTO.getValue());
        AuxCriteriaBuilder.Pair produtoSel = new AuxCriteriaBuilder.Pair((From)jSubOSProd, "nome", GenMapEvtProducaoQtd.PRODUTO.getValue());
        AuxCriteriaBuilder.Pair siglaUnProdSel = new AuxCriteriaBuilder.Pair((From)jSubOSProdUn, "sigla", GenMapEvtProducaoQtd.UN_PRODUTO.getValue());
        AuxCriteriaBuilder.Pair tipoProducaoSel = new AuxCriteriaBuilder.Pair((From)jComProducaoTipoProducao, "tipo", GenMapEvtProducaoQtd.TIPO_PRODUCAO.getValue());
        AuxCriteriaBuilder.Pair dataComSel = new AuxCriteriaBuilder.Pair((From)jComProducao, "dataFinal", GenMapEvtProducaoQtd.DATA.getValue());
        AuxCriteriaBuilder.Pair quantidadeTotalSel = new AuxCriteriaBuilder.Pair((From)jComProducaoitem, "quantidadeTotal", GenMapEvtProducaoQtd.QUANTIDADE_TOTAL.getValue());
        if (usarQuantidadeRef) {
            quantidadeTotalSel = new AuxCriteriaBuilder.Pair((From)jComProducaoitem, "quantidadeTotalRef", GenMapEvtProducaoQtd.QUANTIDADE_TOTAL.getValue());
        }
        AuxCriteriaBuilder.Pair tempoProducaoTotalSel = new AuxCriteriaBuilder.Pair("horaEvento", GenMapEvtProducaoQtd.HORA_PRODUCAO.getValue());
        AuxCriteriaBuilder.Pair tempoProducaoRoteiroTotalSel = new AuxCriteriaBuilder.Pair("horaEventoRoteiro", GenMapEvtProducaoQtd.HORA_PRODUCAO_ROTEIRO.getValue());
        aux.select(identificadorSel, codAuxProdutoSel, produtoSel, siglaUnProdSel, tipoProducaoSel, dataComSel);
        aux.select(aux.getSum(quantidadeTotalSel), aux.getSum(tempoProducaoTotalSel), aux.getSum(tempoProducaoRoteiroTotalSel));
        aux.groupBy(identificadorSel, codAuxProdutoSel, produtoSel, siglaUnProdSel, tipoProducaoSel, dataComSel);
        if (TMethods.isAffirmative((Number)filtrarEquipamento)) {
            aux.equal((From)jEquipamento, "identificador", idEquipamento);
        }
        if (TMethods.isAffirmative((Number)filtrarTipoProducao)) {
            aux.equal((From)jComProducaoTipoProducao, "tipo", tipoProducao.getValue());
        }
        if (TMethods.isAffirmative((Number)filtrarCelula)) {
            aux.equal((From)jCelProd, "identificador", idCelula);
        }
        aux.between((From)jComProducao, "dataFinal", dataInicial, (Comparable)dataFinal);
        List<Map<String, Object>> producoesProdDiaria = aux.getResultMap();
        return this.toGenMapList(producoesProdDiaria, GenMapEvtProducaoQtd.class);
    }

    public List<GenericMapValues<GenMapEvtProducaoTipoEvento>> getApontamentosTipoEvento(short filtrarCelula, Long idCelula, Date dataInicial, Date dataFinal, Short[] tipoEvento) {
        String query = "select  t.tiposFixos as " + GenMapEvtProducaoTipoEvento.CODIGO_TIPO_EVENTO.getValue() + " ,t.descricao as " + GenMapEvtProducaoTipoEvento.TIPO_EVENTO.getValue() + " ,e.dataFechamento as " + GenMapEvtProducaoTipoEvento.DATA.getValue() + " ,sum(e.horaEvento) as " + GenMapEvtProducaoTipoEvento.HORAS_EVENTO.getValue() + " from EventoOsProducaoLinhaProd e inner join e.faseProdutiva f inner join f.celulaProdutiva c inner join e.tipoEvento t where (:filtrarCelula=0 or c.identificador =:idCelula) and e.dataFechamento between :dataInicial and :dataFinal and e.tipoApontEvento in(:tiposEventos) group by t.tiposFixos, t.descricao, e.dataFechamento";
        org.hibernate.query.Query q = this.query(query);
        q.setShort("filtrarCelula", filtrarCelula);
        q.setLong("idCelula", idCelula.longValue());
        q.setDate("dataInicial", TDate.dataSemHora((Date)dataInicial));
        q.setDate("dataFinal", TDate.getLastDateOnDay((Date)dataFinal));
        q.setParameterList("tiposEventos", (Collection)TMethods.toListArray((Object[])tipoEvento));
        List<Map<String, Object>> producoesProdDiaria = this.toHashList((Query)q);
        return this.toGenMapList(producoesProdDiaria, GenMapEvtProducaoTipoEvento.class);
    }
}

