/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Executante;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFechamentoOrdemServicoImpl
extends DaoGenericEntityImpl<FechamentoOrdemServico, Long> {
    public List<FechamentoOrdemServico> findFechamentoOSporExecutanteOcupado(Executante executante, Long idFechamentoOrdemServico) {
        Object query = "SELECT f FROM FechamentoOrdemServico f INNER JOIN f.executantes e WHERE e.pessoa = :pessoa ";
        if (idFechamentoOrdemServico != null) {
            query = (String)query + "AND f.identificador != :fechamentoOrdemServico ";
        }
        query = (String)query + "AND (:dataHoraInicial  BETWEEN e.dataHoraInicio AND e.dataHoraFinal   OR :dataHoraFinal   BETWEEN e.dataHoraInicio AND e.dataHoraFinal   OR e.dataHoraInicio BETWEEN :dataHoraInicial AND :dataHoraFinal   OR e.dataHoraFinal  BETWEEN :dataHoraInicial AND :dataHoraFinal ) ";
        Query q = this.query((String)query);
        q.setParameter("pessoa", (Object)executante.getPessoa());
        if (idFechamentoOrdemServico != null) {
            q.setParameter("fechamentoOrdemServico", (Object)idFechamentoOrdemServico);
        }
        q.setParameter("dataHoraInicial", (Object)executante.getDataHoraInicio());
        q.setParameter("dataHoraFinal", (Object)executante.getDataHoraFinal());
        return q.list();
    }

    public FechamentoOrdemServico getFechamentoByOrdemServico(OrdemServico vo) {
        return (FechamentoOrdemServico)this.toUnique(this.restrictions(this.eq("ordemServico", vo)));
    }
}

