/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoPeriodo;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFechamentoPeriodoImpl
extends DaoGenericEntityImpl<FechamentoPeriodo, Long> {
    public List<Recisao> findRecisoesNaoIntegradas(Date dataInicial, Date dataFinal, Empresa empresa) {
        String hql = "select distinct(r)  from ItemMovimentoRescisao i  inner join i.recisao r where r.dataAfastamento between :dataInicial and :dataFinal  and r.empresa = :empresa  and i.valor > 0 and (i.lancado is null or i.lancado = 0)";
        Query q = this.query(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public FechamentoPeriodo getFechamentoByCalculoInss(CalculoInssEmpresa calculoInss) {
        return (FechamentoPeriodo)this.toUnique(this.restrictions(this.eq("calculoInss", calculoInss)));
    }

    public List<FechamentoPeriodo> getFechamentosPeriodosByCalculoInss(Long idCalculo) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(FechamentoPeriodo.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromFechamentoPeriodo = crit.from(FechamentoPeriodo.class);
            Join jCalculoInssEmpresa = fromFechamentoPeriodo.join("calculoInss", JoinType.INNER);
            crit.select((Selection)fromFechamentoPeriodo);
            exps.add(builder.equal((Expression)jCalculoInssEmpresa.get("identificador"), (Object)idCalculo));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception e) {
            return new ArrayList<FechamentoPeriodo>();
        }
    }
}

