/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Feriado;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFeriadoImpl
extends DaoGenericEntityImpl<Feriado, Long> {
    public Boolean findFeriadoPorData(int dia, int mes, int ano, Empresa empresa) {
        String query = "SELECT count(fa) FROM Feriado fa  inner JOIN fa.empresas e left JOIN fa.anos a WHERE (a.ano = :ano or fa.todoAno=:sim) AND fa.dia = :dia AND fa.mes = :mes AND e.empresa = :empresa";
        org.hibernate.query.Query q = this.query(query);
        q.setInteger("dia", dia);
        q.setInteger("mes", mes);
        q.setInteger("ano", ano);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("sim", (short)1);
        Long l = (Long)q.uniqueResult();
        return l > 0L;
    }

    public List<Feriado> findFeriadosNacionalPorPeriodo(Date periodoInicial, Date periodoFinal, Long idEmpresa) {
        Integer mes = ToolDate.monthFromDate((Date)periodoFinal);
        Integer ano = ToolDate.yearFromDate((Object)periodoFinal);
        Integer diaFinal = ToolDate.dayFromDate((Date)periodoFinal);
        Integer diaInicial = ToolDate.dayFromDate((Date)periodoInicial);
        String hql = " select distinct f  from Feriado f  where  (f.mes = :mesParametro  and  f.todoAno = :sim  and  f.dia >= :diaInicial  and  f.dia <= :diaFinal) or  (exists( select fAno           from FeriadoAno fAno           where           fAno.ano = :anoParametro           and           fAno.feriado.mes = :mesParametro           and          fAno.feriado.dia = :diaInicial          and           fAno.feriado.identificador = f.identificador ) and  exists (select fEmpresa          from FeriadoEmpresa fEmpresa          where          fEmpresa.empresa.identificador = :idEmpresa          and          fEmpresa.feriado.identificador = f.identificador))";
        List ret = this.query(hql).setInteger("mesParametro", mes.intValue()).setInteger("anoParametro", ano.intValue()).setLong("idEmpresa", idEmpresa.longValue()).setInteger("diaFinal", diaFinal.intValue()).setInteger("diaInicial", diaInicial.intValue()).setShort("sim", (short)1).list();
        return ret;
    }

    public Boolean isFeriadoNacional(Date data, Empresa empresa) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        return this.findFeriadoPorData(g.get(5), g.get(2) + 1, g.get(1), empresa);
    }

    public Feriado findFeriadoPorDataAndCidade(Date data, Cidade cidade) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        int dia = g.get(5);
        int mes = g.get(2) + 1;
        int ano = g.get(1);
        String query = "SELECT DISTINCT fa  FROM Feriado fa  left JOIN fa.anos a  left JOIN fa.cidades c  WHERE (a.ano = :ano or fa.todoAno=:sim)  AND fa.dia = :dia  AND fa.mes = :mes  AND (fa.tipoFeriado = :feriadoNacional OR c.cidade = :cidade)";
        org.hibernate.query.Query q = this.query(query);
        q.setInteger("dia", dia);
        q.setInteger("mes", mes);
        q.setInteger("ano", ano);
        q.setEntity("cidade", (Object)cidade);
        q.setShort("sim", (short)1);
        q.setShort("feriadoNacional", (short)1);
        q.setMaxResults(1);
        return (Feriado)q.uniqueResult();
    }

    public boolean isFeriadoNacional(Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        int dia = g.get(5);
        int mes = g.get(2) + 1;
        int ano = g.get(1);
        String query = "SELECT DISTINCT count(fa)  FROM Feriado fa  left JOIN fa.anos a  left JOIN fa.cidades c  WHERE (a.ano = :ano or fa.todoAno=:sim)  AND fa.dia = :dia  AND fa.mes = :mes  AND (fa.tipoFeriado = :feriadoNacional)";
        org.hibernate.query.Query q = this.query(query);
        q.setInteger("dia", dia);
        q.setInteger("mes", mes);
        q.setInteger("ano", ano);
        q.setShort("sim", (short)1);
        q.setShort("feriadoNacional", (short)1);
        q.setMaxResults(1);
        Long res = this.countOf((Query)q);
        return res > 0L;
    }

    public List<Feriado> getFeriadosNacionais() {
        AuxCriteriaBuilder builder = this.queryBuilder();
        builder.equal("tipoFeriado", (short)1);
        return builder.getResultEnt();
    }
}

