/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocItemS1010;
import com.touchcomp.basementor.model.vo.EsocItemS1020;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.ItemRemessaFolhaCnab;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import com.touchcomp.basementorclientwebservices.ponto.model.abono.DTOPontoFeriasColaborador;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFeriasColaboradorImpl
extends DaoGenericEntityImpl<FeriasColaborador, Long> {
    public List<FeriasColaborador> getFerias(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        String hql = " from FeriasColaborador ferias  where  ferias.periodoAqFeriasColab.colaborador = :colaborador  and  (ferias.dataGozoInicial between :inicioApuracao and :finalApuracao  or  ferias.dataGozoFinal between :inicioApuracao and :finalApuracao)";
        return this.query(hql).setEntity("colaborador", (Object)colaborador).setDate("inicioApuracao", inicioApuracao).setDate("finalApuracao", finalApuracao).list();
    }

    public List<FeriasColaborador> getFeriasPorPeriodoAqFeriasColab(PeriodoAqFeriasColab periodoFerias) {
        return this.restrictions(this.eq("periodoAqFeriasColab", periodoFerias)).list();
    }

    public List<FeriasColaborador> getFeriasColaboradorPorColaborador(Long idColaborador) {
        CriteriaBuilder builder = this.criteriaBuilder(FeriasColaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromFeriasColaborador = crit.from(FeriasColaborador.class);
        Join jPeriodoAqFeriasColab = fromFeriasColaborador.join("periodoAqFeriasColab", JoinType.INNER);
        Join jColaborador = jPeriodoAqFeriasColab.join("colaborador", JoinType.INNER);
        crit.select((Selection)fromFeriasColaborador);
        exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<FeriasColaborador> getFerias(Long colaborador, Date dataParametro) {
        Criteria c = this.criteria();
        c.createAlias("periodoAqFeriasColab", "p");
        c.createAlias("p.colaborador", "c");
        c.add(this.eq("c.identificador", colaborador));
        c.add(this.greatherEqual("dataGozoFinal", dataParametro));
        c.add(this.lessEqual("dataGozoInicial", dataParametro));
        return c.list();
    }

    public List<FeriasColaborador> findFeriasNaoIntegradas(Date dataInicial, Date dataFinal, Long empresa) {
        CriteriaBuilder builder = this.criteriaBuilder(FeriasColaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromFeriasColaborador = crit.from(FeriasColaborador.class);
        Join jPeriodoFerias = fromFeriasColaborador.join("periodoFerias", JoinType.INNER);
        Join jEmpresa = jPeriodoFerias.join("empresa", JoinType.INNER);
        LinkedList<Predicate> subExps = new LinkedList<Predicate>();
        Subquery subquery = crit.subquery(Long.class);
        Root fromItemMovimentoFerias = subquery.from(ItemMovimentoFerias.class);
        Join jItemIntegracaoFeriasFolha = fromItemMovimentoFerias.join("itensFolhaFerias", JoinType.INNER);
        subquery.select((Expression)fromItemMovimentoFerias.get("identificador"));
        subExps.add(builder.equal((Expression)fromItemMovimentoFerias.get("ferias"), (Expression)fromFeriasColaborador));
        subquery.where(subExps.toArray(new Predicate[0]));
        crit.select((Selection)fromFeriasColaborador);
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)empresa));
        exps.add(builder.between((Expression)fromFeriasColaborador.get("dataGozoInicial"), (Comparable)dataInicial, (Comparable)dataFinal));
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<FeriasColaborador> findMovimentosS1200(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(FeriasColaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(FeriasColaborador.class);
        Join jPeriodoFerias = root.join("periodoFerias", JoinType.INNER);
        Join jEmpresa = jPeriodoFerias.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupoEmpresa));
        exps.add(builder.between((Expression)root.get("dataPagamento"), (Comparable)dataInicial, (Comparable)dataFinal));
        Subquery subquery = crit.subquery(EsocItemS1010.class);
        Root fromEsocItem = subquery.from(EsocItemS1010.class);
        Join jFerias = fromEsocItem.join("ferias", JoinType.INNER);
        subquery.where((Expression)builder.equal((Expression)jFerias.get("identificador"), (Expression)root.get("identificador")));
        subquery.select((Expression)fromEsocItem);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<FeriasColaborador> findMovimentosS1210(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(FeriasColaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(FeriasColaborador.class);
        Join jPeriodoFerias = root.join("periodoFerias", JoinType.INNER);
        Join jEmpresa = jPeriodoFerias.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupoEmpresa));
        exps.add(builder.between((Expression)root.get("dataPagamento"), (Comparable)dataInicial, (Comparable)dataFinal));
        Subquery subquery = crit.subquery(EsocItemS1020.class);
        Root fromEsocItem = subquery.from(EsocItemS1020.class);
        Join jFerias = fromEsocItem.join("feriasColaborador", JoinType.INNER);
        subquery.where((Expression)builder.equal((Expression)jFerias.get("identificador"), (Expression)root.get("identificador")));
        subquery.select((Expression)fromEsocItem);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<DTOPontoFeriasColaborador> findFeriasColaboradorPonto(Date dataBaseSincSistemaPonto, Date dataUltimaSincronizacao) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jPeriodoFerias = aux.join("periodoFerias");
        Join jjPeriodoAqFerias = aux.join("periodoAqFeriasColab");
        Join jColaborador = jjPeriodoAqFerias.join("colaborador");
        aux.select((From)jColaborador, "numeroRegistro");
        aux.select("dataGozoInicial");
        aux.select("dataGozoFinal");
        aux.select((From)jColaborador, "identificador");
        LinkedList<Predicate> where = new LinkedList<Predicate>();
        where.add(aux.and(aux.isNotNull((From)jPeriodoFerias, "dataCadastro"), aux.gt((From)jPeriodoFerias, "dataCadastro", dataBaseSincSistemaPonto)));
        if (TMethods.isNotNull((Object)dataUltimaSincronizacao).booleanValue()) {
            where.add(aux.gt((From)jPeriodoFerias, "dataAtualizacao", dataUltimaSincronizacao));
        }
        aux.where(where);
        List data = aux.getResult();
        LinkedList<DTOPontoFeriasColaborador> result = new LinkedList<DTOPontoFeriasColaborador>();
        for (Object[] obj : data) {
            DTOPontoFeriasColaborador dto = new DTOPontoFeriasColaborador();
            dto.setMatricula((String)obj[0]);
            dto.setDtInicio((Date)obj[1]);
            dto.setDtFim((Date)obj[2]);
            dto.setIdColaborador((Long)obj[3]);
            result.add(dto);
        }
        return result;
    }

    public List<FeriasColaborador> findFeriasColaboradorPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        CriteriaBuilder builder = this.criteriaBuilder(FeriasColaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(FeriasColaborador.class);
        Join jPeriodoFerias = root.join("periodoFerias", JoinType.INNER);
        exps.add(builder.equal((Expression)jPeriodoFerias.get("empresa"), (Object)empresa));
        exps.add(builder.equal((Expression)root.get("dataPagamento"), (Object)dataPagamento));
        Subquery subqueryFerias = crit.subquery(ItemOutrosTitulosFolha.class);
        Root fromItemOutrosTitulosFolha = subqueryFerias.from(ItemOutrosTitulosFolha.class);
        Join jFeriasColaborador = fromItemOutrosTitulosFolha.join("feriasColaborador", JoinType.INNER);
        subqueryFerias.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)jFeriasColaborador.get("identificador"), (Expression)root.get("identificador"))}));
        subqueryFerias.select((Expression)fromItemOutrosTitulosFolha);
        Subquery subqueryCnab = crit.subquery(ItemRemessaFolhaCnab.class);
        Root fromItemRemessaFolhaCnab = subqueryCnab.from(ItemRemessaFolhaCnab.class);
        Join jFeriasColaboradorCnab = fromItemRemessaFolhaCnab.join("feriasColaborador", JoinType.INNER);
        subqueryCnab.where((Expression)builder.and(new Predicate[]{builder.equal((Expression)jFeriasColaboradorCnab.get("identificador"), (Expression)root.get("identificador"))}));
        subqueryCnab.select((Expression)fromItemRemessaFolhaCnab);
        exps.add(builder.not((Expression)builder.exists(subqueryFerias)));
        exps.add(builder.not((Expression)builder.exists(subqueryCnab)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public FeriasColaborador getUltimaFerias(Colaborador colaborador, Date dataLimite) {
        Criteria c = this.criteria();
        c.createAlias("periodoAqFeriasColab", "p");
        c.add(this.eq("p.colaborador", colaborador));
        c.add(this.lessEqual("dataGozoFinal", dataLimite));
        c.addOrder(Order.desc((String)"dataGozoFinal"));
        c.setMaxResults(1);
        return (FeriasColaborador)c.uniqueResult();
    }
}

