/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.FormulacaoFases;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFormulacaoFasesImpl
extends DaoGenericEntityImpl<FormulacaoFases, Long> {
    public FormulacaoFases getByCodProdRevisao(String codigoAuxiliarProd, String revisao) {
        Criteria c = this.criteria();
        c.createAlias("roteiroProducao", "r");
        c.createAlias("r.roteiroProducaoGrCor", "rgc");
        c.createAlias("rgc.gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        return (FormulacaoFases)this.toUnique(this.restrictions(c, this.eq("p.codigoAuxiliar", codigoAuxiliarProd), this.eq("ativo", (short)1), this.eq("revisao", revisao)));
    }

    public FormulacaoFases getByCodProdRevisao(Long idProduto, String revisao) {
        Criteria c = this.criteria();
        c.createAlias("roteiroProducao", "r");
        c.createAlias("r.roteiroProducaoGrCor", "rgc");
        c.createAlias("rgc.gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        return (FormulacaoFases)this.toUnique(this.restrictions(c, this.eq("p.identificador", idProduto), this.eq("ativo", (short)1), this.eq("revisao", revisao)));
    }

    public List<FormulacaoFases> findFormulacoesByRoteiro(RoteiroProducao roteiro) {
        Criteria c = this.criteria();
        c.add(this.eq("roteiroProducao", roteiro));
        c.add(this.eq("ativo", EnumConstStatusObjeto.ATIVO.getValue()));
        this.order(c, "descricao");
        return c.list();
    }
}

