/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFornecedorImpl
extends DaoGenericEntityImpl<Fornecedor, Long> {
    public List<Fornecedor> getByCNPJCPF(String cnpjCpf) {
        Query q = this.query("select distinct f FROM Fornecedor f WHERE f.pessoa.complemento.cnpj = :cnpjCpf");
        q.setParameter("cnpjCpf", (Object)cnpjCpf);
        return q.getResultList();
    }

    public Fornecedor getFornecedorCpfCpnjAtivo(String cnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("p.complemento", "c");
        crit.setMaxResults(1);
        return (Fornecedor)this.toUnique(this.restrictions(crit, this.eq("c.cnpj", cnpj), this.eq("ativo", (short)1)));
    }

    public Fornecedor getFornecedorCpfCpnjInscEstAtivo(String cnpj, String inscEst) {
        inscEst = ToolString.removerZerosAEsquerda((String)inscEst);
        Query q = this.query("FROM Fornecedor c WHERE c.pessoa.complemento.cnpj = :cnpj and trim(LEADING 0 FROM c.pessoa.complemento.inscEst) = :inscEst and c.pessoa.ativo = :ativo");
        q.setParameter("cnpj", (Object)cnpj);
        q.setParameter("inscEst", (Object)inscEst);
        q.setParameter("ativo", (Object)1);
        q.setMaxResults(1);
        try {
            return (Fornecedor)q.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public Fornecedor get(Pessoa pessoa) {
        return (Fornecedor)this.toUnique(this.restrictions(this.eq("pessoa", pessoa)));
    }

    public List<Fornecedor> get(Pessoa pessoa, Short ativo) {
        return this.toList(this.restrictions(this.eq("pessoa", pessoa), this.eq("ativo", ativo)));
    }

    public PlanoConta getPCFornecedor(Pessoa pessoa) {
        Criteria crit = this.criteria();
        crit.setProjection((Projection)Projections.property((String)"planoConta"));
        crit.add(this.eq("pessoa", pessoa));
        return (PlanoConta)crit.uniqueResult();
    }

    public boolean exists(String cpfCnpj) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jPessoa = aux.join("pessoa");
        Join jComplemento = jPessoa.join("complemento");
        aux.equal((From)jComplemento, "cnpj", cpfCnpj);
        aux.select(new Selection[]{aux.countOf("identificador")});
        Number ret = (Number)aux.getUniqueGenericResult();
        return ret != null && ret.doubleValue() > 0.0;
    }
}

