/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.SituacaoCotacaoCompra;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFornecedorItemCotacaoCompraImpl
extends DaoGenericEntityImpl<FornecedorItemCotacaoCompra, Long> {
    public List<FornecedorItemCotacaoCompra> getFornecedoresCotacaoCompra(Fornecedor fornecedor, SituacaoCotacaoCompra situacaoCotacaoLibPortalForn, SituacaoCotacaoCompra situacaoAvisoFornecedores, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.createAlias("itemCotacaoCompra", "item", JoinType.INNER_JOIN);
        crit.createAlias("item.cotacaoCompra", "cot", JoinType.INNER_JOIN);
        crit.createAlias("unidadeFaturamentoFornecedor", "unid", JoinType.INNER_JOIN);
        this.restrictions(crit, this.eq("unid.fornecedor", fornecedor), this.or(this.eq("cot.situacaoCotacaoCompra", situacaoCotacaoLibPortalForn), this.eq("cot.situacaoCotacaoCompra", situacaoAvisoFornecedores)), this.eq("cot.fechada", EnumConstantsMentorSimNao.NAO.value), this.eq("cot.empresa", empresa));
        return this.toList(crit);
    }

    public List<FornecedorItemCotacaoCompra> getFornecedores(Long cotacao) {
        Criteria c = this.criteria();
        c.createAlias("itemCotacaoCompra", "i");
        c.createAlias("fornecedorItemCotacaoCompraLivroFiscal", "fornLiv");
        c.createAlias("fornLiv.cfop", "cfop", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("fornLiv.unidadeFederativaIcmsSt", "ufIcmsSt", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("fornLiv.categoriaSt", "catSt", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("fornLiv.modalidadeIcmsSt", "modIcmsSt", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("unidadeFaturamentoFornecedor", "unfat");
        c.createAlias("unfat.pessoa", "pessoa");
        c.createAlias("pessoa.complemento", "complemento");
        c.createAlias("pessoa.endereco", "endereco");
        c.createAlias("i.cotacaoCompra", "c");
        c.createAlias("cotacaoMoeda", "cotMoeda", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("cotMoeda.moeda", "cotMoedaMoeda", JoinType.LEFT_OUTER_JOIN);
        c.setFetchMode("modeloFiscal", FetchMode.JOIN);
        c.setFetchMode("fornLiv", FetchMode.JOIN);
        c.setFetchMode("catSt", FetchMode.JOIN);
        c.setFetchMode("modIcmsSt", FetchMode.JOIN);
        c.setFetchMode("cfop", FetchMode.JOIN);
        c.setFetchMode("ufIcmsSt", FetchMode.JOIN);
        c.setFetchMode("tipoFrete", FetchMode.JOIN);
        c.setFetchMode("planoConta", FetchMode.JOIN);
        c.setFetchMode("condicoesPagamento", FetchMode.JOIN);
        c.setFetchMode("planoContaGerencial", FetchMode.JOIN);
        c.setFetchMode("p", FetchMode.JOIN);
        c.setFetchMode("e", FetchMode.JOIN);
        c.setFetchMode("comp", FetchMode.JOIN);
        c.setFetchMode("unfat", FetchMode.JOIN);
        c.setFetchMode("pessoa", FetchMode.JOIN);
        c.setFetchMode("complemento", FetchMode.JOIN);
        c.setFetchMode("endereco", FetchMode.JOIN);
        c.setFetchMode("marca", FetchMode.JOIN);
        c.setFetchMode("moeda", FetchMode.JOIN);
        c.setFetchMode("cotMoeda", FetchMode.JOIN);
        c.setFetchMode("cotMoedaMoeda", FetchMode.JOIN);
        c.setFetchMode("motivoAquisPref", FetchMode.JOIN);
        c.setFetchMode("leadTimeFornProduto", FetchMode.JOIN);
        c.setFetchMode("itemCotacaoCompra", FetchMode.JOIN);
        c.add(this.eq("c.identificador", cotacao));
        c.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return c.list();
    }
}

