/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.DTOPontoCargo;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFuncaoImpl
extends DaoGenericEntityImpl<Funcao, Long> {
    public List<DTOPontoCargo> findFuncoesPonto(Date dataBaseSincSistemaPonto, Date dataUltimaSincronizacao) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jCbo = aux.join("cbo");
        aux.select("identificador");
        aux.select("descricao");
        aux.select("dataAtualizacao");
        aux.select((From)jCbo, "identificador");
        aux.select((From)jCbo, "descricao");
        aux.select((From)jCbo, "codigo");
        LinkedList<Predicate> where = new LinkedList<Predicate>();
        where.add(aux.and(aux.isNotNull("dataCadastro"), aux.gt("dataCadastro", dataBaseSincSistemaPonto)));
        if (TMethods.isNotNull((Object)dataUltimaSincronizacao).booleanValue()) {
            where.add(aux.gt("dataAtualizacao", dataUltimaSincronizacao));
        }
        aux.where(where);
        List data = aux.getResult();
        LinkedList<DTOPontoCargo> result = new LinkedList<DTOPontoCargo>();
        for (Object[] obj : data) {
            DTOPontoCargo dto = new DTOPontoCargo();
            dto.setExternalId(String.valueOf(obj[0]));
            dto.setDescricao((String)obj[1]);
            Timestamp dataAtualizacao = (Timestamp)obj[2];
            if (dataAtualizacao != null) {
                dto.setAlterationDate(Long.valueOf(dataAtualizacao.getTime()));
            }
            dto.setCboId((Long)obj[3]);
            dto.setCbo((String)obj[4]);
            dto.setCodigoCbo((String)obj[5]);
            result.add(dto);
        }
        return result;
    }

    public Funcao getByCodigoCBO(String codigoCbo) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jCbo = aux.join("cbo");
        aux.equal((From)jCbo, "codigo", codigoCbo);
        return (Funcao)aux.getUniqueResult();
    }

    public Funcao getByCodigo(String codCargo) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("codigoCargo", codCargo);
        return (Funcao)aux.getUniqueResult();
    }
}

