/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.GeracaoReciboRpa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoGeracaoReciboRpaImpl
extends DaoGenericEntityImpl<GeracaoReciboRpa, Long> {
    public Map getValoreRpaAnteriorInss(Long geracaoReciboRpa, Long colaborador, Date periodoFolha, Boolean novoRegistro) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jColaborador = aux.join("colaborador");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorRpa", "valorRpa")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrInss", "vlrInss")));
        if (novoRegistro.booleanValue()) {
            aux.le((From)aux.from(), "identificador", geracaoReciboRpa);
        } else {
            aux.lt((From)aux.from(), "identificador", geracaoReciboRpa);
        }
        aux.equal((From)jColaborador, "identificador", colaborador);
        aux.equal((From)aux.from(), "periodoFolha", periodoFolha);
        return aux.getUniqueResultMap();
    }

    public Map getValoreRpaAnteriorIrrf(Long geracaoReciboRpa, Long colaborador, Date dataPagamento) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jColaborador = aux.join("colaborador");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorRpa", "valorRpa")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrIrrf", "vlrIrrf")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrInss", "vlrInss")));
        aux.notEqual((From)aux.from(), "identificador", geracaoReciboRpa);
        aux.equal((From)jColaborador, "identificador", colaborador);
        aux.le((From)aux.from(), "dataPagamento", dataPagamento);
        aux.ge((From)aux.from(), "dataPagamento", ToolDate.getDateFirstMonthDay((Date)dataPagamento));
        return aux.getUniqueResultMap();
    }

    public Long getRpaPosteriores(Long geracaoReciboRpa, Long colaborador, Date periodoFolha, Date dataPagamento) {
        CriteriaBuilder builder = this.criteriaBuilder(GeracaoReciboRpa.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromGeracaoReciboRpa = crit.from(GeracaoReciboRpa.class);
        Join jColaborador = fromGeracaoReciboRpa.join("colaborador", JoinType.INNER);
        crit.select((Selection)builder.count((Expression)fromGeracaoReciboRpa));
        exps.add(builder.notEqual((Expression)fromGeracaoReciboRpa.get("identificador"), (Object)geracaoReciboRpa));
        exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)colaborador));
        exps.add(builder.equal((Expression)fromGeracaoReciboRpa.get("periodoFolha"), (Object)periodoFolha));
        exps.add(builder.greaterThan((Expression)fromGeracaoReciboRpa.get("dataPagamento"), (Comparable)dataPagamento));
        crit.where(exps.toArray(new Predicate[0]));
        return (Long)this.getEntityManager().createQuery(crit).getSingleResult();
    }

    public List<GeracaoReciboRpa> getGeracaoReciboRpaPorPeriodoFolha(Date dataInicial, Date dataFinal) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(GeracaoReciboRpa.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromGeracaoReciboRpa = crit.from(GeracaoReciboRpa.class);
            crit.select((Selection)fromGeracaoReciboRpa);
            exps.add(builder.between((Expression)fromGeracaoReciboRpa.get("periodoFolha"), (Comparable)dataInicial, (Comparable)dataFinal));
            Predicate valorRpaPositivo = builder.greaterThan((Expression)fromGeracaoReciboRpa.get("valorRpa"), (Comparable)Double.valueOf(0.0));
            Predicate valorInssPositivo = builder.greaterThan((Expression)fromGeracaoReciboRpa.get("vlrInss"), (Comparable)Double.valueOf(0.0));
            Predicate valorIrrfPositivo = builder.greaterThan((Expression)fromGeracaoReciboRpa.get("vlrIrrf"), (Comparable)Double.valueOf(0.0));
            Predicate valorIssPositivo = builder.greaterThan((Expression)fromGeracaoReciboRpa.get("vlrIss"), (Comparable)Double.valueOf(0.0));
            exps.add(builder.or(new Predicate[]{valorRpaPositivo, valorInssPositivo, valorIrrfPositivo, valorIssPositivo}));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception e) {
            return new ArrayList<GeracaoReciboRpa>();
        }
    }

    public GeracaoReciboRpa getUltimaGeracaoReciboRpaPorColaborador(Long idColaborador) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(GeracaoReciboRpa.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromGeracaoReciboRpa = crit.from(GeracaoReciboRpa.class);
            Join jColaborador = fromGeracaoReciboRpa.join("colaborador", JoinType.INNER);
            crit.select((Selection)fromGeracaoReciboRpa);
            exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
            crit.orderBy(new Order[]{builder.desc((Expression)fromGeracaoReciboRpa.get("identificador"))});
            crit.where(exps.toArray(new Predicate[0]));
            return (GeracaoReciboRpa)this.getEntityManager().createQuery(crit).setMaxResults(1).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }
}

