/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.res.DTOGradeCorRes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoGradeCorImpl
extends DaoGenericEntityImpl<GradeCor, Long> {
    @Override
    public List<GradeCor> get(Produto produto) {
        if (produto != null) {
            return this.getGradesAtivasByProduto(produto.getIdentificador());
        }
        return new ArrayList<GradeCor>();
    }

    public GradeCor getFirstGradeCor(Produto produto) {
        Query q = this.query("select gc from GradeCor gc inner join gc.produtoGrade pg inner join pg.produto p where p = :produto and gc.ativo = :ativo");
        q.setMaxResults(1);
        q.setEntity("produto", (Object)produto);
        q.setShort("ativo", (short)1);
        return (GradeCor)q.uniqueResult();
    }

    public GradeCor getByCodigoBarras(String codigo) {
        return (GradeCor)this.toUnique(this.restrictions(this.eq("codigoBarras", codigo), this.eq("ativo", (short)1)));
    }

    public GradeCor getGradeCorProdutoNome(Produto produto, String gradeCor) {
        Query q = this.query("select gc from GradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p where p = :produto and c.nome = :gradeCor and gc.ativo = :ativo");
        q.setMaxResults(1);
        q.setEntity("produto", (Object)produto);
        q.setString("gradeCor", gradeCor);
        q.setShort("ativo", (short)1);
        return (GradeCor)q.uniqueResult();
    }

    public GradeCor getGradePrincipalbyProduto(Produto produto) {
        if (produto == null) {
            return null;
        }
        List<GradeCor> grades = this.getByIdProduto(produto.getIdentificador(), 1, EnumConstantsMentorSimNao.NAO.getValue(), EnumConstantsMentorSimNao.SIM.getValue());
        return grades.isEmpty() ? null : grades.get(0);
    }

    public List<GradeCor> getByIdProduto(Long idProduto) {
        return this.getByIdProduto(idProduto, null, EnumConstantsMentorSimNao.NAO.getValue(), EnumConstantsMentorSimNao.NAO.getValue());
    }

    public List<GradeCor> getByIdProdutoAtivo(Long idProduto) {
        return this.getByIdProduto(idProduto, null, EnumConstantsMentorSimNao.SIM.getValue(), EnumConstantsMentorSimNao.NAO.getValue());
    }

    public List<GradeCor> getByIdProduto(Long idProduto, Integer maxRegs, Short filtrarProdutosAtivos, Short filtrarGradePrincipal) {
        Criteria c = this.criteria();
        c.createAlias("produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        c.add(this.eq("p.identificador", idProduto));
        c.add(this.eq("ativo", (short)1));
        if (TMethods.isAffirmative((Number)filtrarProdutosAtivos)) {
            c.add(this.eq("p.ativo", (short)1));
        }
        if (ToolMethods.isAffirmative((Number)filtrarGradePrincipal)) {
            c.add(this.eq("gradePrincipal", EnumConstantsMentorSimNao.SIM.getValue()));
        }
        if (TMethods.isWithData((Number)maxRegs)) {
            c.setMaxResults(maxRegs.intValue());
        }
        c.addOrder(Order.desc((String)"gradePrincipal"));
        c.addOrder(Order.desc((String)"identificador"));
        return this.toList(c);
    }

    public List<GradeCor> getByCodAuxProduto(String codAuxProduto) {
        return this.getFirstByCodAuxProduto(codAuxProduto, null, EnumConstantsMentorSimNao.NAO.getValue());
    }

    public List<GradeCor> getByCodAuxProdutoAtivo(String codAuxProduto) {
        return this.getFirstByCodAuxProduto(codAuxProduto, null, EnumConstantsMentorSimNao.SIM.getValue());
    }

    public List<GradeCor> getFirstByCodAuxProduto(String codAuxProduto, Integer maxRegs, Short filtrarProdutoAtivo) {
        Criteria c = this.criteria();
        c.createAlias("produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        c.add(this.eq("p.codigoAuxiliar", codAuxProduto));
        c.add(this.eq("ativo", (short)1));
        if (TMethods.isAffirmative((Number)filtrarProdutoAtivo)) {
            c.add(this.eq("p.ativo", (short)1));
        }
        if (TMethods.isWithData((Number)maxRegs)) {
            c.setMaxResults(maxRegs.intValue());
        }
        c.addOrder(Order.desc((String)"gradePrincipal"));
        c.addOrder(Order.desc((String)"identificador"));
        return this.toList(c);
    }

    public List<GradeCor> getFirstByCodigoBarrasProduto(String codBarrasProd, Integer maxRegs) {
        Criteria c = this.criteria();
        c.createAlias("produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        c.createAlias("p.codigoBarras", "pc");
        c.add(this.eq("pc.codigoBarras", codBarrasProd));
        c.add(this.eq("ativo", (short)1));
        if (TMethods.isWithData((Number)maxRegs)) {
            c.setMaxResults(maxRegs.intValue());
        }
        c.addOrder(Order.desc((String)"gradePrincipal"));
        c.addOrder(Order.desc((String)"identificador"));
        return this.toList(c);
    }

    public List<DTOGradeCorRes> getGrades(Long idProduto, String strTyped, boolean useIlike) {
        Criteria c = this.criteria();
        c.createAlias("produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        c.createAlias("p.unidadeMedida", "u");
        c.createAlias("cor", "c");
        c.add(this.eq("p.identificador", idProduto));
        c.add(this.eq("ativo", (short)1));
        if (ToolString.stringIsANumberInteger((String)strTyped).booleanValue() && strTyped.length() < 10) {
            c.add(this.eq("identificador", Long.valueOf(strTyped)));
        } else if (useIlike) {
            c.add(this.likeRight("c.nome", strTyped));
        } else {
            c.add(this.ilike("c.nome", strTyped));
        }
        ProjectionList fields = Projections.projectionList();
        fields.add((Projection)Projections.property((String)"identificador"));
        fields.add((Projection)Projections.property((String)"c.nome"));
        fields.add((Projection)Projections.property((String)"p.codigoAuxiliar"));
        fields.add((Projection)Projections.property((String)"p.nome"));
        fields.add((Projection)Projections.property((String)"u.sigla"));
        fields.add((Projection)Projections.property((String)"p.identificador"));
        c.setProjection((Projection)fields);
        List res = c.list();
        LinkedList<DTOGradeCorRes> ret = new LinkedList<DTOGradeCorRes>();
        res.forEach(i -> {
            DTOGradeCorRes a = new DTOGradeCorRes();
            Long id = (Long)i[0];
            String corNome = (String)i[1];
            String prodCodAux = (String)i[2];
            String prodNome = (String)i[3];
            String un = (String)i[4];
            Long idProd = (Long)i[5];
            a.setIdentificador(id);
            a.setCorNome(corNome);
            a.setProdutoCodigoAuxiliar(prodCodAux);
            a.setProdutoNome(prodNome);
            a.setProdutoUnidadeMedidaSigla(un);
            a.setProdutoIdentificador(idProd);
            ret.add(a);
        });
        return ret;
    }

    public GradeCor getFirtByIdProduto(Long idProd) {
        List<GradeCor> grades = this.getByIdProduto(idProd, 1, EnumConstantsMentorSimNao.NAO.getValue(), EnumConstantsMentorSimNao.NAO.getValue());
        return grades.isEmpty() ? null : grades.get(0);
    }

    public GradeCor getFirstByCodigoBarrasProduto(String codBarrasProd) {
        List<GradeCor> grades = this.getFirstByCodigoBarrasProduto(codBarrasProd, 1);
        return grades.isEmpty() ? null : grades.get(0);
    }

    public GradeCor getFirstByCodAuxProduto(String codAuxProd) {
        List<GradeCor> grades = this.getFirstByCodAuxProduto(codAuxProd, 1, EnumConstantsMentorSimNao.NAO.getValue());
        return grades.isEmpty() ? null : grades.get(0);
    }

    public List<GradeCor> findGradeItemPedidoByProdutoExcAll(Produto produto, List<GradeItemPedido> grades) {
        if (produto == null || grades == null) {
            return new ArrayList<GradeCor>();
        }
        Criteria c = this.criteria();
        c.createAlias("produtoGrade", "pg");
        c.add(this.eq("pg.produto", produto));
        c.add(this.eq("ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        Disjunction d = Restrictions.disjunction();
        d.add(this.isNull("gradePrincipal"));
        d.add(this.notEqual("gradePrincipal", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add((Criterion)d);
        for (GradeItemPedido g : grades) {
            c.add(this.notEqual("identificador", g.getGradeCor().getIdentificador()));
        }
        this.order(c, "indice");
        return c.list();
    }

    public List<GradeCor> getGradesAtivasByProduto(Long produto) {
        Criteria c = this.criteria();
        c.createAlias("produtoGrade", "pg");
        c.createAlias("cor", "c");
        c.createAlias("pg.produto", "p");
        c.createAlias("p.unidadeMedida", "um");
        c.add(this.eq("p.identificador", produto));
        c.add(this.eq("ativo", EnumConstStatusObjeto.ATIVO.getValue()));
        return c.list();
    }

    public GradeCor getGradeSeProdutoAtivo(Long identificador) {
        Criteria c = this.criteria();
        c.createAlias("produtoGrade", "pg");
        c.createAlias("cor", "c");
        c.createAlias("pg.produto", "p");
        c.createAlias("p.unidadeMedida", "um");
        c.add(this.eq("identificador", identificador));
        c.add(this.eq("ativo", EnumConstStatusObjeto.ATIVO.getValue()));
        c.add(this.eq("p.ativo", EnumConstStatusObjeto.ATIVO.getValue()));
        return (GradeCor)c.uniqueResult();
    }

    public Map<String, Object> getMapDadosBaseGradeCor(GradeCor grade) {
        Criteria c = this.criteria();
        c.createAlias("produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        c.createAlias("p.unidadeMedida", "u");
        c.createAlias("p.especie", "e");
        c.createAlias("p.subEspecie", "se");
        c.createAlias("cor", "c");
        c.add(this.eq("identificador", grade.getIdentificador()));
        ProjectionList fields = Projections.projectionList();
        fields.add(Projections.alias((Projection)Projections.property((String)"p.identificador"), (String)"ID_PRODUTO"));
        fields.add(Projections.alias((Projection)Projections.property((String)"p.codigoAuxiliar"), (String)"CODIGO_AUXILIAR"));
        fields.add(Projections.alias((Projection)Projections.property((String)"p.nome"), (String)"PRODUTO"));
        fields.add(Projections.alias((Projection)Projections.property((String)"c.nome"), (String)"GRADE"));
        fields.add(Projections.alias((Projection)Projections.property((String)"identificador"), (String)"ID_GRADE_COR"));
        fields.add(Projections.alias((Projection)Projections.property((String)"p.qtdMin"), (String)"QTD_MIN"));
        fields.add(Projections.alias((Projection)Projections.property((String)"p.qtdMax"), (String)"QTD_MAX"));
        fields.add(Projections.alias((Projection)Projections.property((String)"e.nome"), (String)"ESPECIE"));
        fields.add(Projections.alias((Projection)Projections.property((String)"se.nome"), (String)"SUB_ESPECIE"));
        fields.add(Projections.alias((Projection)Projections.property((String)"u.sigla"), (String)"UNIDADE_MEDIDA"));
        fields.add(Projections.alias((Projection)Projections.property((String)"p.pontoRessupEstoque"), (String)"PTO_RESSUPRIMENTO"));
        c.setProjection((Projection)fields);
        return this.toHashUnique(c);
    }
}

