/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.impl.VOEngenhariaProdutos;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.TipoProducaoSped;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.dao.resulttransformer.ResultTransfFormulacaoEngProdutos;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoGradeFormulaProdutoImpl
extends DaoGenericEntityImpl<GradeFormulaProduto, Long> {
    public List<VOEngenhariaProdutos> getFormulacoesByGrupoProdutosEngProd(Long idInicial, Long idFinal, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormAtivas) {
        Query q = this.query("select distinct g.identificador as ID_FORMULACAO ,p.identificador as ID_PRODUTO ,g.quantidadeReferenciaProd as QTD_REF ,c.nome as NOME_FORMULACAO ,p.nome as PRODUTO ,p.qtdMin as QTD_MIN ,p.qtdMax as QTD_MAX ,p.pontoRessupEstoque as QTD_RESSUPRIMENTO ,p.codigoAuxiliar as COD_AUX_PRODUTO ,un.sigla as UN_PRODUTO ,e.nome as ESPECIE_PRODUTO ,g.descricao as NOME_FORMULACAO ,gc.identificador as ID_GRADE_COR ,s.nome as SUB_ESPECIE_PRODUTO, tis.codigo as COD_TIPO_ITEM_SPED, tis.descricao as TIPO_ITEM_SPED from GradeFormulaProduto g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p inner join p.unidadeMedida un inner join p.grupoProdutos gr left join p.especie e left join p.subEspecie s left join p.tipoIemSped tis where gr.identificador between :grupoInicial and :grupoFinal and (:somenteFormulacoesAtivas = 0 or g.ativo = :sim) and (:filtrarEspecie = 0 or e.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubEspecie = 0 or s.identificador between :idSubEspecieInicial and :idSubEspecieFinal)");
        q.setLong("grupoInicial", idInicial.longValue());
        q.setLong("grupoFinal", idFinal.longValue());
        q.setShort("sim", (short)1);
        q.setShort("somenteFormulacoesAtivas", somenteFormAtivas.value);
        q.setLong("idEspecieInicial", idInicialEspecie.longValue());
        q.setLong("idEspecieFinal", idFinalEspecie.longValue());
        q.setShort("filtrarEspecie", filtraEspecie.value);
        q.setLong("idSubEspecieInicial", idInicialSubEspecie.longValue());
        q.setLong("idSubEspecieFinal", idFinalSubEspecie.longValue());
        q.setShort("filtrarSubEspecie", filtraSubEspecie.value);
        q.setResultTransformer((ResultTransformer)new ResultTransfFormulacaoEngProdutos());
        List ret = q.list();
        return ret;
    }

    public List<VOEngenhariaProdutos> getFormulacoesEngProd(Long idInicial, Long idFinal, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormAtivas) {
        Query q = this.query("select distinct g.identificador as ID_FORMULACAO ,p.identificador as ID_PRODUTO ,g.quantidadeReferenciaProd as QTD_REF ,c.nome as GRADE_PRODUTO ,p.nome as PRODUTO ,p.qtdMin as QTD_MIN ,p.qtdMax as QTD_MAX ,p.pontoRessupEstoque as QTD_RESSUPRIMENTO ,p.codigoAuxiliar as COD_AUX_PRODUTO ,un.sigla as UN_PRODUTO ,e.nome as ESPECIE_PRODUTO ,g.descricao as NOME_FORMULACAO ,gc.identificador as ID_GRADE_COR ,s.nome as SUB_ESPECIE_PRODUTO, tis.codigo as COD_TIPO_ITEM_SPED, tis.descricao as TIPO_ITEM_SPED from GradeFormulaProduto g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p inner join p.unidadeMedida un left join p.especie e left join p.subEspecie s left join p.tipoIemSped tis where g.identificador between :formIn and :formFim  and (:somenteFormulacoesAtivas = 0 or g.ativo = :sim) and (:filtrarEspecie = 0 or e.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubEspecie = 0 or s.identificador between :idSubEspecieInicial and :idSubEspecieFinal)");
        q.setShort("somenteFormulacoesAtivas", somenteFormAtivas.value);
        q.setLong("formIn", idInicial.longValue());
        q.setLong("formFim", idFinal.longValue());
        q.setShort("sim", (short)1);
        q.setLong("idEspecieInicial", idInicialEspecie.longValue());
        q.setLong("idEspecieFinal", idFinalEspecie.longValue());
        q.setShort("filtrarEspecie", filtraEspecie.value);
        q.setLong("idSubEspecieInicial", idInicialSubEspecie.longValue());
        q.setLong("idSubEspecieFinal", idFinalSubEspecie.longValue());
        q.setShort("filtrarSubEspecie", filtraSubEspecie.value);
        q.setResultTransformer((ResultTransformer)new ResultTransfFormulacaoEngProdutos());
        List ret = q.list();
        return ret;
    }

    public List<VOEngenhariaProdutos> getFormulacoesByProdutoEngProd(Long idInicial, Long idFinal, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormAtivas) {
        Query q = this.query("select distinct g.identificador as ID_FORMULACAO, p.identificador as ID_PRODUTO ,g.quantidadeReferenciaProd as QTD_REF, c.nome as GRADE_PRODUTO, p.nome as PRODUTO ,p.qtdMin as QTD_MIN ,p.qtdMax as QTD_MAX ,p.pontoRessupEstoque as QTD_RESSUPRIMENTO, p.codigoAuxiliar as COD_AUX_PRODUTO, un.sigla as UN_PRODUTO, e.nome as ESPECIE_PRODUTO, g.descricao as NOME_FORMULACAO, gc.identificador as ID_GRADE_COR, s.nome as SUB_ESPECIE_PRODUTO, tis.codigo as COD_TIPO_ITEM_SPED, tis.descricao as TIPO_ITEM_SPED from GradeFormulaProduto g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p left join p.unidadeMedida un left join p.especie e left join p.subEspecie s left join p.tipoIemSped tis where p.identificador between :prodInicial and :prodFinal and (:somenteFormulacoesAtivas = 0 or g.ativo = :sim) and (:filtrarEspecie =0 or e.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubEspecie =0 or s.identificador between :idSubEspecieInicial and :idSubEspecieFinal)");
        q.setLong("prodInicial", idInicial.longValue());
        q.setLong("prodFinal", idFinal.longValue());
        q.setShort("sim", (short)1);
        q.setShort("somenteFormulacoesAtivas", somenteFormAtivas.value);
        q.setLong("idEspecieInicial", idInicialEspecie.longValue());
        q.setLong("idEspecieFinal", idFinalEspecie.longValue());
        q.setShort("filtrarEspecie", filtraEspecie.value);
        q.setLong("idSubEspecieInicial", idInicialSubEspecie.longValue());
        q.setLong("idSubEspecieFinal", idFinalSubEspecie.longValue());
        q.setShort("filtrarSubEspecie", filtraSubEspecie.value);
        q.setResultTransformer((ResultTransformer)new ResultTransfFormulacaoEngProdutos());
        List ret = q.list();
        return ret;
    }

    public List<VOEngenhariaProdutos> getItensFormulacaoEngProd(Long idFormulacao) {
        Query q = this.query("select p.identificador as ID_PRODUTO ,p.nome as PRODUTO ,gg.quantidadeReferenciaProd as QTD_REF ,p.qtdMin as QTD_MIN ,p.qtdMax as QTD_MAX ,p.pontoRessupEstoque as QTD_RESSUPRIMENTO ,p.codigoAuxiliar as COD_AUX_PRODUTO ,c.nome as GRADE_PRODUTO ,un.sigla as UN_PRODUTO ,e.nome as ESPECIE_PRODUTO ,s.nome as SUB_ESPECIE_PRODUTO ,g.quantidade as QUANTIDADE ,gc.identificador aS ID_GRADE_COR ,gg.descricao aS NOME_FORMULACAO, tis.codigo as COD_TIPO_ITEM_SPED, tis.descricao as TIPO_ITEM_SPED from ItemGradeFormulaProduto g inner join g.gradeFormulaProduto gg inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p left join p.especie e left join p.subEspecie s left join p.unidadeMedida un left join p.tipoIemSped tis where gg.identificador =:idForm");
        q.setLong("idForm", idFormulacao.longValue());
        q.setResultTransformer((ResultTransformer)new ResultTransfFormulacaoEngProdutos());
        List ret = q.list();
        return ret;
    }

    public Long getPrimeiroIdGradeFormulaProdutoAtivaEngProd(Long idGradeCor, EnumConstantsMentorSimNao somenteFormAtivas) {
        Query q = this.query("select g.identificador from GradeFormulaProduto g inner join g.gradeCor gc where gc.identificador =:idGrade and (:somenteFormulacoesAtivas = 0 or g.ativo = :sim)");
        q.setLong("idGrade", idGradeCor.longValue());
        q.setShort("sim", (short)1);
        q.setShort("somenteFormulacoesAtivas", somenteFormAtivas.value);
        q.setMaxResults(1);
        return (Long)q.uniqueResult();
    }

    public List<VOEngenhariaProdutos> getFormulacoesEngProdPrincProd(Long idInicial, Long idFinal, EnumConstantsMentorSimNao filtraEspecie, Long idInicialEspecie, Long idFinalEspecie, EnumConstantsMentorSimNao filtraSubEspecie, Long idInicialSubEspecie, Long idFinalSubEspecie, EnumConstantsMentorSimNao somenteFormAtivas) {
        Query q = this.query("select distinct g.identificador as ID_FORMULACAO, p.identificador as ID_PRODUTO ,g.quantidadeReferenciaProd as QTD_REF, c.nome as GRADE_PRODUTO, p.nome as PRODUTO ,p.qtdMin as QTD_MIN ,p.qtdMax as QTD_MAX ,p.pontoRessupEstoque as QTD_RESSUPRIMENTO, p.codigoAuxiliar as COD_AUX_PRODUTO, un.sigla as UN_PRODUTO, e.nome as ESPECIE_PRODUTO, g.descricao as NOME_FORMULACAO, gc.identificador as ID_GRADE_COR, s.nome as SUB_ESPECIE_PRODUTO, tis.codigo as COD_TIPO_ITEM_SPED, tis.descricao as TIPO_ITEM_SPED from GradeFormulaProduto g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p left join p.unidadeMedida un left join p.especie e left join p.subEspecie s left join p.tipoIemSped tis where p.identificador between :prodInicial and :prodFinal and (:somenteFormulacoesAtivas = 0 or g.ativo = :sim) and g.formulacaoPrincipal = :sim and (:filtrarEspecie =0 or e.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubEspecie =0 or s.identificador between :idSubEspecieInicial and :idSubEspecieFinal)");
        q.setLong("prodInicial", idInicial.longValue());
        q.setLong("prodFinal", idFinal.longValue());
        q.setShort("sim", (short)1);
        q.setShort("somenteFormulacoesAtivas", somenteFormAtivas.value);
        q.setLong("idEspecieInicial", idInicialEspecie.longValue());
        q.setLong("idEspecieFinal", idFinalEspecie.longValue());
        q.setShort("filtrarEspecie", filtraEspecie.value);
        q.setLong("idSubEspecieInicial", idInicialSubEspecie.longValue());
        q.setLong("idSubEspecieFinal", idFinalSubEspecie.longValue());
        q.setShort("filtrarSubEspecie", filtraSubEspecie.value);
        q.setResultTransformer((ResultTransformer)new ResultTransfFormulacaoEngProdutos());
        List ret = q.list();
        return ret;
    }

    public GradeFormulaProduto get(TipoProducaoSped tipoProducaoSped, GradeCor gradeCor) {
        return this.get(tipoProducaoSped, gradeCor, null);
    }

    public GradeFormulaProduto get(TipoProducaoSped tipoProducao, GradeCor gradeCor, String revisao) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jTpProd = builder.join("gradeFormProdTpSpedProd");
        builder.equal("gradeCor", gradeCor);
        builder.equal("formulacaoPrincipal", (short)1);
        builder.equal("ativo", (short)1);
        if (revisao != null) {
            builder.equal("revisao", revisao);
        }
        builder.equal((From)jTpProd, "tipoProducaoSped", tipoProducao);
        builder.orderAsc("identificador");
        return (GradeFormulaProduto)builder.getUniqueResult();
    }

    public List<GradeFormulaProduto> getFormulacoesAltCriadas(Date lastDateSync, Long idGrupoProdutos) {
        Criteria crit = this.criteria();
        crit.createAlias("itemGradeFormulaProduto", "it");
        crit.createAlias("gradeCor", "gc");
        crit.createAlias("gc.produtoGrade", "pg");
        crit.createAlias("pg.produto", "p");
        Disjunction or = Restrictions.or((Criterion[])new Criterion[0]);
        if (ToolMethods.isWithData((Number)idGrupoProdutos)) {
            crit.createAlias("p.grupoProdutosRel", "gpr");
            crit.createAlias("gpr.grupoProdutosRel", "gp");
            crit.add(this.eq("gp.identificador", idGrupoProdutos));
            or.add(this.greatherEqual("gpr.dataAtualizacao", lastDateSync));
            or.add(this.greatherEqual("gp.dataAtualizacao", lastDateSync));
        }
        or.add(this.greatherEqual("dataAtualizacao", lastDateSync));
        or.add(this.greatherEqual("it.dataAtualizacao", lastDateSync));
        or.add(this.greatherEqual("p.dataAtualizacao", lastDateSync));
        or.add(this.greatherEqual("gc.dataAtualizacao", lastDateSync));
        or.add(this.greatherEqual("pg.dataAtualizacao", lastDateSync));
        crit.add((Criterion)or);
        crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<GradeFormulaProduto> data = this.toList(crit);
        return data;
    }

    public GradeFormulaProduto findMelhorGradeFormulaProduto(GradeCor gradeCor) {
        String query = "select\ng\nfrom GradeFormulaProduto g\nwhere g.gradeCor = :gradeCor\nand g.ativo = :ativo\norder by g.formulacaoPrincipal,\ng.identificador";
        Query q = this.query(query);
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (GradeFormulaProduto)q.uniqueResult();
    }

    public GradeFormulaProduto getByCodProdRevisao(String codigoAuxiliar, String revisao) {
        Criteria c = this.criteria();
        c.createAlias("gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        return (GradeFormulaProduto)this.toUnique(this.restrictions(c, this.eq("ativo", (short)1), this.eq("p.codigoAuxiliar", codigoAuxiliar), this.eq("revisao", revisao)));
    }

    public GradeFormulaProduto getFormulacaoPrincipal(GradeCor gradeCor, Long idFormulacao) {
        if (idFormulacao == null) {
            idFormulacao = 0L;
        }
        return (GradeFormulaProduto)this.toUnique(this.restrictions(this.eq("gradeCor", gradeCor), this.eq("ativo", (short)1), this.eq("formulacaoPrincipal", (short)1), this.notEqual("identificador", idFormulacao)));
    }

    public GradeFormulaProduto getByCodProdRevisao(Long idProduto, String revisao) {
        Criteria c = this.criteria();
        c.createAlias("gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        return (GradeFormulaProduto)this.toUnique(this.restrictions(c, this.eq("ativo", (short)1), this.eq("p.identificador", idProduto), this.eq("revisao", revisao)));
    }

    public GradeFormulaProduto getByIdGradeCorRevisao(Long idGradeCor, String revisao) {
        Criteria c = this.criteria();
        c.createAlias("gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        return (GradeFormulaProduto)this.toUnique(this.restrictions(c, this.eq("ativo", (short)1), this.eq("gc.identificador", idGradeCor), this.eq("revisao", revisao)));
    }

    public GradeFormulaProduto getByGradeCorRevisao(GradeCor gradeCor, String revisao, Long idFormulacao) {
        if (idFormulacao == null) {
            idFormulacao = 0L;
        }
        Criteria c = this.criteria();
        return (GradeFormulaProduto)this.toUnique(this.restrictions(c, this.eq("ativo", (short)1), this.eq("gradeCor", gradeCor), this.eq("revisao", revisao), this.notEqual("identificador", idFormulacao)));
    }

    public GradeFormulaProduto getFormulacaoPrincipal(Long idGradeFormula) {
        return (GradeFormulaProduto)this.toUnique(this.restrictions(this.eq("identificador", idGradeFormula), this.eq("ativo", (short)1), this.eq("formulacaoPrincipal", EnumConstantsMentorSimNao.SIM.getValue())));
    }

    public List<GradeFormulaProduto> getGradesFormulas(Long gradeCor, EnumConstantsMentorSimNao filtrarAtivos) {
        Criteria c = this.criteria();
        c.createAlias("gradeCor", "gc");
        c.add(this.eq("gc.identificador", gradeCor));
        if (ToolMethods.isEquals((Object)filtrarAtivos, (Object)EnumConstantsMentorSimNao.SIM)) {
            c.add(this.eq("ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        }
        c.addOrder(Order.asc((String)"descricao"));
        return c.list();
    }

    public List<GradeFormulaProduto> getGradesFormulas(Long gradeCor) {
        return this.getGradesFormulas(gradeCor, EnumConstantsMentorSimNao.NAO);
    }
}

