/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoGradeItemNotaFiscalPropriaImpl
extends DaoGenericEntityImpl<GradeItemNotaFiscalPropria, Long> {
    public List<DTORastreioLoteFabricacao> rastreioLoteNotaPropria(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        Criteria c = this.criteria();
        c.createAlias("loteFabricacao", "lf");
        c.createAlias("itemNotaFiscalPropria", "i");
        c.createAlias("i.notaFiscalPropria", "nfp");
        c.createAlias("gradeCor", "gc");
        c.createAlias("gc.cor", "cor");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        c.createAlias("nfp.naturezaOperacao", "no");
        ProjectionList select = Projections.projectionList();
        select.add((Projection)Projections.property((String)"nfp.identificador"), "identificador");
        select.add((Projection)Projections.property((String)"no.entradaSaida"), "entradaSaida");
        select.add((Projection)Projections.property((String)"nfp.dataEntradaSaida"), "dataEntradaSaida");
        select.add((Projection)Projections.property((String)"nfp.dataEmissaoNota"), "dataEmissao");
        select.add((Projection)Projections.property((String)"quantidade"), "quantidade");
        select.add((Projection)Projections.property((String)"lf.loteFabricacao"), "loteFabricacao");
        select.add((Projection)Projections.property((String)"p.identificador"), "produtoIdentificador");
        select.add((Projection)Projections.property((String)"p.nome"), "produto");
        select.add((Projection)Projections.property((String)"cor.nome"), "cor");
        select.add((Projection)Projections.property((String)"nfp.serie"), "serie");
        select.add((Projection)Projections.property((String)"nfp.numeroNota"), "numeroNota");
        c.setProjection((Projection)select);
        if (dataInicial != null && dataFinal != null) {
            c.add(this.greatherEqual("nfp.dataEntradaSaida", dataInicial));
            c.add(this.lessEqual("nfp.dataEntradaSaida", dataFinal));
        }
        if (produtoInicial != null && produtoFinal != null) {
            c.add(this.greatherEqual("p.identificador", produtoInicial));
            c.add(this.lessEqual("p.identificador", produtoFinal));
        }
        c.add(this.in("lf.identificador", loteFabricacao));
        c.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DTORastreioLoteFabricacao.class));
        return c.list();
    }
}

