/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoGradeItemNotaTerceirosImpl
extends DaoGenericEntityImpl<GradeItemNotaTerceiros, Long> {
    public List<GradeItemNotaTerceiros> getGradesProdSobEncSemVincOS(Date dataIn, Date dataFim, Empresa empresa) {
        org.hibernate.query.Query q = this.query("select distinct g from GradeItemNotaTerceiros g inner join g.itemNotaTerceiros i inner join i.notaFiscalTerceiros nf inner join i.itemNotaLivroFiscal il inner join il.cfop cf  where cf.cfopIndustrializacao = :industrializacao and g.dataEntradaSaida between :dataIn and :dataFim and nf.empresa = :empresa and not exists( select os from OrdemServicoProdLinhaProd os where os.gradeItemNotaTerceiros = g)");
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFim);
        q.setShort("industrializacao", EnumConstantsMentorSimNao.SIM.value);
        return this.toList((Query)q);
    }

    public List<GradeItemNotaTerceiros> getGrades(Date lastDateSync, Long idGrupoProdutos) {
        Object query = "select distinct g from GradeItemNotaTerceiros g inner join g.itemNotaTerceiros i inner join i.notaFiscalTerceiros nf inner join nf.liberacaoNFTerceiros l";
        query = (String)query + " where l.conferidaTotalmente=:sim and (g.dataAtualizacao>=:data_atualizacao or nf.dataAtualizacao>=:data_atualizacao or l.dataAtualizacao >=:data_atualizacao) ";
        String exists = " and exists( select ii from ItemGradeFormulaProduto ii where ii.gradeCor = g.gradeCor)";
        if (ToolMethods.isWithData((Number)idGrupoProdutos)) {
            exists = "  and exists( select ii from ItemGradeFormulaProduto ii  inner join ii.gradeFormulaProduto gf inner join gf.gradeCor gcf inner join gcf.produtoGrade pg inner join pg.produto p inner join p.grupoProdutosRel gpr inner join gpr.grupoProdutosRel gp where ii.gradeCor = g.gradeCor and gp.identificador=:id_grupo)";
        }
        query = (String)query + exists;
        org.hibernate.query.Query q = this.query((String)query);
        q.setDate("data_atualizacao", lastDateSync);
        q.setShort("sim", (short)1);
        if (ToolMethods.isWithData((Number)idGrupoProdutos)) {
            q.setLong("id_grupo", idGrupoProdutos.longValue());
        }
        return q.list();
    }

    public List<DTORastreioLoteFabricacao> rastreioLoteNotaTerceiros(Date dataInicial, Date dataFinal, List loteFabricacao, Long produtoInicial, Long produtoFinal) {
        Criteria c = this.criteria();
        c.createAlias("itemNotaTerceiros", "i");
        c.createAlias("i.notaFiscalTerceiros", "nft");
        c.createAlias("loteFabricacao", "lf");
        c.createAlias("gradeCor", "gc");
        c.createAlias("gc.cor", "cor");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        ProjectionList select = Projections.projectionList();
        select.add((Projection)Projections.property((String)"nft.identificador"), "identificador");
        select.add((Projection)Projections.property((String)"nft.dataEntrada"), "dataEntradaSaida");
        select.add((Projection)Projections.property((String)"nft.dataEmissao"), "dataEmissao");
        select.add((Projection)Projections.property((String)"quantidade"), "quantidade");
        select.add((Projection)Projections.property((String)"lf.loteFabricacao"), "loteFabricacao");
        select.add((Projection)Projections.property((String)"p.identificador"), "produtoIdentificador");
        select.add((Projection)Projections.property((String)"p.nome"), "produto");
        select.add((Projection)Projections.property((String)"cor.nome"), "cor");
        select.add((Projection)Projections.property((String)"nft.serie"), "serie");
        select.add((Projection)Projections.property((String)"nft.numeroNota"), "numeroNota");
        c.setProjection((Projection)select);
        if (dataInicial != null && dataFinal != null) {
            c.add(this.greatherEqual("nft.dataEntrada", dataInicial));
            c.add(this.lessEqual("nft.dataEntrada", dataFinal));
        }
        if (produtoInicial != null && produtoFinal != null) {
            c.add(this.greatherEqual("p.identificador", produtoInicial));
            c.add(this.lessEqual("p.identificador", produtoFinal));
        }
        c.add(this.in("lf.identificador", loteFabricacao));
        c.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DTORastreioLoteFabricacao.class));
        return c.list();
    }
}

