/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoGrupoDeBaixaFormasImpl
extends DaoGenericEntityImpl<GrupoDeBaixaFormas, Long> {
    public GrupoDeBaixaFormas getGrupoDeBaixaVinculadoCompensacao(GrupoDeBaixa grupo) {
        return (GrupoDeBaixaFormas)this.toUnique(this.restrictions(this.eq("grupoBaixaCompensacao", grupo)));
    }

    public List<GrupoDeBaixaFormas> baixasPorPeriodo(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        String q = "select distinct gbf   from GrupoDeBaixa b  inner join b.grupoDeBaixaFormas gbf  left join gbf.integracaoBaixaTituloGrupoBaixaFormas integ where b.dataLiquidacao between :dataInicial and :dataFinal  and integ.loteContabil is null and b.empresa.empresaDados.grupoEmpresa = :grupoEmpresa";
        Query query = this.query(q);
        query.setParameter("dataInicial", (Object)dataInicial);
        query.setParameter("dataFinal", (Object)dataFinal);
        query.setParameter("grupoEmpresa", (Object)grupoEmpresa);
        return query.list();
    }
}

