/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementorclientwebservices.ponto.model.horario.DTOPontoHorario;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.springframework.stereotype.Repository;

@Repository
public class DaoHorarioTrabalhoImpl
extends DaoGenericEntityImpl<HorarioTrabalho, Long> {
    public HorarioTrabalho getHorarioTrabalho(Empresa empresa, Date data, Double hora) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jDiaHorario = aux.join("diaHorarioTrabalho");
        Join jDiaHorarioPer = aux.join((From)jDiaHorario, "periodosTrabalho");
        aux.where(aux.equal("empresa", empresa), aux.between("dataInicial", "dataFinal", (Comparable)data), aux.between((From)jDiaHorarioPer, "horaInicial", "horaFinal", (Comparable)hora));
        return (HorarioTrabalho)aux.getUniqueResult();
    }

    public List<DTOPontoHorario> findHorariosTrabalhoPonto() {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEsocCadastroHorario = aux.join("esocCadastroHorario");
        Join jListaHorario = jEsocCadastroHorario.join("listaHorario");
        aux.select((From)jEmpresa, "identificador");
        aux.select((From)jListaHorario, "horarioInicial");
        aux.select((From)jListaHorario, "inicioIntervalo");
        aux.select((From)jListaHorario, "finalIntervalo");
        aux.select((From)jListaHorario, "horarioFinal");
        aux.select("identificador");
        aux.select("descricao");
        List data = aux.getResult();
        LinkedList<DTOPontoHorario> result = new LinkedList<DTOPontoHorario>();
        for (Object[] obj : data) {
            DTOPontoHorario dto = new DTOPontoHorario();
            dto.setIdEmpresa((Long)obj[0]);
            dto.setHorario1((Date)obj[1]);
            dto.setHorario2((Date)obj[2]);
            dto.setHorario3((Date)obj[3]);
            dto.setHorario4((Date)obj[4]);
            dto.setIdHorario((Long)obj[5]);
            dto.setHorario((String)obj[6]);
            result.add(dto);
        }
        return result;
    }

    public HorarioTrabalho getHorarioTrabalhoDescricao(String descricao) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("descricao", String.valueOf(descricao).toUpperCase());
        return (HorarioTrabalho)aux.getUniqueResult();
    }
}

