/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoImplantacaoSaldosImpl
extends DaoGenericEntityImpl<ImplantacaoSaldos, Long> {
    public Double getUltimoCusto(Long idProduto, Long idEmpresa) {
        String query = "select g.valorUltCustoUnit  from ImplantacaoSaldos c inner join c.itemImplantaSaldo i inner join i.gradeItem g where i.produto.identificador = :idProduto and c.empresa.identificador = :idEmpresa and c.dataEntradaSaida=( select max(c1.dataEntradaSaida) from ImplantacaoSaldos c1 inner join c1.itemImplantaSaldo i1 where c1.empresa = c.empresa and i1.produto = i.produto)  order by c.identificador desc";
        Query q = this.query(query);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setLong("idProduto", idProduto.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public Double getUltimoCusto(Long idProduto, Long idEmpresa, Date dataBase) {
        String query = "select g.valorUltCustoUnit  from ImplantacaoSaldos c inner join c.itemImplantaSaldo i inner join i.gradeItem g where i.produto.identificador = :idProduto and c.empresa.identificador = :idEmpresa and c.dataEntradaSaida=( select max(c1.dataEntradaSaida) from ImplantacaoSaldos c1 inner join c1.itemImplantaSaldo i1 where c1.empresa = c.empresa and i1.produto = i.produto and c1.dataEntradaSaida>=:dataBase)  order by c.identificador desc";
        Query q = this.query(query);
        q.setDate("dataBase", dataBase);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setLong("idProduto", idProduto.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public Double getUltimoCusto(Long idProduto) {
        String query = "select g.valorUltCustoUnit  from ImplantacaoSaldos c inner join c.itemImplantaSaldo i inner join i.gradeItem g where i.produto.identificador = :idProduto and c.dataEntradaSaida=( select max(c1.dataEntradaSaida) from ImplantacaoSaldos c1 inner join c1.itemImplantaSaldo i1 where  i1.produto = i.produto)  order by c.identificador desc";
        Query q = this.query(query);
        q.setLong("idProduto", idProduto.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public Double getUltimoCusto(Long idProduto, Date dataBase) {
        String query = "select g.valorUltCustoUnit  from ImplantacaoSaldos c inner join c.itemImplantaSaldo i inner join i.gradeItem g where i.produto.identificador = :idProduto and c.dataEntradaSaida=( select max(c1.dataEntradaSaida) from ImplantacaoSaldos c1 inner join c1.itemImplantaSaldo i1 where  i1.produto = i.produto and c1.dataEntradaSaida>=:dataBase)  order by c.identificador desc";
        Query q = this.query(query);
        q.setDate("dataBase", dataBase);
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataBase", dataBase);
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public List<DTORastreioLoteFabricacao> rastreioLoteImplantacaoSaldo(Date dataInicial, Date dataFinal, List lotes, Long produtoInicial, Long produtoFinal) {
        Criteria c = this.criteria();
        c.createAlias("itemImplantaSaldo", "i");
        c.createAlias("i.gradeItem", "g");
        c.createAlias("g.gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("gc.cor", "cor");
        c.createAlias("pg.produto", "p");
        c.createAlias("g.loteFabricacao", "lf");
        ProjectionList select = Projections.projectionList();
        select.add((Projection)Projections.property((String)"identificador"), "identificador");
        select.add((Projection)Projections.property((String)"dataEntradaSaida"), "dataEntradaSaida");
        select.add((Projection)Projections.property((String)"dataCadastro"), "dataCadastro");
        select.add((Projection)Projections.property((String)"g.quantidade"), "quantidade");
        select.add((Projection)Projections.property((String)"lf.loteFabricacao"), "loteFabricacao");
        select.add((Projection)Projections.property((String)"p.identificador"), "produtoIdentificador");
        select.add((Projection)Projections.property((String)"p.nome"), "produto");
        select.add((Projection)Projections.property((String)"cor.nome"), "cor");
        c.setProjection((Projection)select);
        c.add(this.in("lf.identificador", lotes));
        if (dataInicial != null) {
            c.add(this.greatherEqual("dataEntradaSaida", dataInicial));
        }
        if (dataFinal != null) {
            c.add(this.lessEqual("dataEntradaSaida", dataFinal));
        }
        if (produtoInicial != null) {
            c.add(this.greatherEqual("p.identificador", produtoInicial));
        }
        if (produtoFinal != null) {
            c.add(this.lessEqual("p.identificador", produtoFinal));
        }
        c.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DTORastreioLoteFabricacao.class));
        return c.list();
    }
}

