/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.businessintelligence.EnumConstBITipoPublicidade;
import com.touchcomp.basementor.model.vo.ImportacaoBi;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoImportacaoBiImpl
extends DaoGenericEntityImpl<ImportacaoBi, Long> {
    public Long getMaxNrControle() {
        Query q = this.query("select max(cast(r.numeroControle as long)) from ImportacaoBi r");
        return (Long)q.uniqueResult();
    }

    public ImportacaoBi getBySerial(String serialLocalBI) {
        return (ImportacaoBi)this.toUnique(this.restrictions(this.eq("serialLocalBI", serialLocalBI)));
    }

    public List<Map<String, Object>> getImportacaoBIMap(Long idNodo) {
        String hql = " select distinct  i.identificador as ID_IMPORTACAO_BI, i.descricao as DESCRICAO_BI, i.numeroBI as NUMERO_BI, i.tipoClassificacaoBI as TIPO_CLASSIFICACAO_BI, i.serialLocalBI as SERIAL_LOCAL_BI from ImportacaoBi i  inner join i.repositorios r  inner join r.nodos n  where n.identificador = :nodo  and i.inativo =:nao order by i.descricao";
        return this.query(hql).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).setLong("nodo", idNodo.longValue()).setShort("nao", (short)0).list();
    }

    public List<ImportacaoBi> getImportacaoBILiberacao(Integer qtdRegistros, EnumConstTipoRepositorioBI tipoRepo) {
        Criteria crit = this.criteria();
        crit.createAlias("repositorios", "r");
        crit.createAlias("r.versaosRepositorioBI", "v");
        crit.setMaxResults(qtdRegistros.intValue());
        return this.toList(this.restrictions(crit, this.eq("v.publicado", (short)0), this.eq("tipoRepositorioBI", tipoRepo.getValue())));
    }

    public List<Map<String, Object>> getImportacoesAtivasNodo(Long idNodo, String baseCnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria crit = this.criteria(baseCnpj, tipo);
        crit.createAlias("r.nodos", "n");
        crit.add(this.eq("n.identificador", idNodo));
        this.fields(crit, new String[][]{{"identificador", "identificador"}, {"descricao", "descricao"}, {"serialLocalBI", "serialLocalBI"}, {"numeroControle", "numeroControle"}, {"tipoClassificacaoBI", "tipoClassificacaoBI"}, {"numeroBI", "numeroBI"}, {"r.identificador", "ridentificador"}, {"r.numeroVersao", "rnumeroVersao"}, {"r.descricao", "rdescricao"}, {"r.nomeBi", "rnomeBi"}, {"r.alteracao", "ralteracao"}, {"v.identificador", "videntificador"}, {"v.numeroVersao", "vnumeroVersao"}, {"v.descricaoAlteracoes", "vdescricaoAlteracoes"}});
        return this.toHashList(crit);
    }

    public List<Map<String, Object>> getImportacoesBIAtivas(String search, String baseCnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria crit = this.criteria(baseCnpj, tipo);
        if (ToolString.isALongNumber((String)search)) {
            crit.add(this.or(this.eq("numeroBI", Long.valueOf(search))));
        } else {
            crit.add(this.or(this.ilike("r.nomeBi", search), this.ilike("descricao", search)));
        }
        this.fields(crit, new String[][]{{"identificador", "identificador"}, {"descricao", "descricao"}, {"serialLocalBI", "serialLocalBI"}, {"numeroControle", "numeroControle"}, {"tipoClassificacaoBI", "tipoClassificacaoBI"}, {"numeroBI", "numeroBI"}, {"r.identificador", "ridentificador"}, {"r.numeroVersao", "rnumeroVersao"}, {"r.descricao", "rdescricao"}, {"r.nomeBi", "rnomeBi"}, {"r.alteracao", "ralteracao"}, {"v.identificador", "videntificador"}, {"v.numeroVersao", "vnumeroVersao"}, {"v.descricaoAlteracoes", "vdescricaoAlteracoes"}});
        return this.toHashList(crit);
    }

    public List<Map<String, Object>> getImportacoesAtivasDescricao(String descricao, String baseCnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria crit = this.criteria(baseCnpj, tipo);
        if (TMethods.isStrWithData((String)descricao)) {
            if (descricao.startsWith(" ")) {
                crit.add(this.ilike("r.nomeBi", descricao));
            } else {
                crit.add(this.ilikeRight("r.nomeBi", descricao));
            }
        }
        this.fields(crit, new String[][]{{"identificador", "identificador"}, {"descricao", "descricao"}, {"serialLocalBI", "serialLocalBI"}, {"numeroControle", "numeroControle"}, {"tipoClassificacaoBI", "tipoClassificacaoBI"}, {"numeroBI", "numeroBI"}, {"r.identificador", "ridentificador"}, {"r.numeroVersao", "rnumeroVersao"}, {"r.descricao", "rdescricao"}, {"r.nomeBi", "rnomeBi"}, {"r.alteracao", "ralteracao"}, {"v.identificador", "videntificador"}, {"v.numeroVersao", "vnumeroVersao"}, {"v.descricaoAlteracoes", "vdescricaoAlteracoes"}});
        return this.toHashList(crit);
    }

    public List<ImportacaoBi> getImportacoesAtivasNumeroBI(Long numeroBI, String baseCnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria crit = this.criteria(baseCnpj, tipo);
        crit.add(this.eq("numeroBI", numeroBI));
        return this.toList(crit);
    }

    public List<Map<String, Object>> getImportacoesBI(String baseCnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria crit = this.criteria(baseCnpj, tipo);
        this.fields(crit, new String[][]{{"cl.identificador", "idClassificacao"}, {"cl.descricao", "classificacao"}, {"descricao", "descricao"}, {"identificador", "identificador"}, {"numeroControle", "numeroControle"}, {"serialLocalBI", "serialLocalBI"}, {"numeroBI", "numeroBI"}, {"tipoClassificacaoBI", "tipoClassificacaoBI"}, {"observacoes", "observacoes"}, {"r.identificador", "idRepositorio"}, {"r.numeroVersao", "numeroVersaoRep"}, {"r.descricao", "descricaoRep"}, {"r.inativo", "inativoRep"}, {"r.nomeBi", "nomeBi"}, {"v.identificador", "identificadorVersao"}, {"v.numeroVersao", "numeroVersaoVer"}, {"v.dataLiberacao", "dataLiberacao"}, {"v.nrAleatorioAcesso", "nrAleatorioAcesso"}, {"v.publicado", "publicado"}, {"v.inativo", "inativoVer"}, {"vm.codigo", "codigoVersaoMin"}, {"v.descricaoAlteracoes", "descricaoAlteracoes"}, {"r.alteracao", "alteracao"}});
        return this.toHashList(crit);
    }

    public List<ImportacaoBi> getImportacoesBINumeroAleatorio(String nrAleatorioAcesso, String baseCnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria crit = this.criteria();
        crit.add(this.eq("v.nrAleatorioAcesso", nrAleatorioAcesso));
        crit.add(this.eq("r.tipo", tipo.getValue()));
        crit.add(this.or(this.eq("tipoPublicidadeBI", EnumConstBITipoPublicidade.BI_PUBLICO.getValue()), this.and(this.eq("tipoPublicidadeBI", EnumConstBITipoPublicidade.BI_PRIVADO.getValue()), this.eq("c.baseCNPJ", baseCnpj))));
        return this.toList(crit);
    }

    public List<ImportacaoBi> getImportaocaoBINodo(Nodo nodo, EnumConstTipoRepositorioBI tipo) {
        String hql = " select distinct r.importacaoBi  from RepositorioBi r  inner join r.nodos nn  where  nn = :nodo ";
        return this.query(hql).setParameter("nodo", (Object)nodo).list();
    }

    public List<Map<String, Object>> getBIRepositorioDestaque(String cnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria crit = this.criteria(cnpj, tipo);
        crit.add(this.greather("scoreDestaque", (short)0));
        crit.setMaxResults(30);
        crit.addOrder(Order.desc((String)"scoreDestaque"));
        this.fields(crit, new String[][]{{"identificador", "identificador"}, {"descricao", "descricao"}, {"serialLocalBI", "serialLocalBI"}, {"numeroControle", "numeroControle"}, {"tipoClassificacaoBI", "tipoClassificacaoBI"}, {"numeroBI", "numeroBI"}, {"r.identificador", "ridentificador"}, {"r.numeroVersao", "rnumeroVersao"}, {"r.descricao", "rdescricao"}, {"r.nomeBi", "rnomeBi"}, {"r.alteracao", "ralteracao"}, {"v.identificador", "videntificador"}, {"v.numeroVersao", "vnumeroVersao"}, {"v.descricaoAlteracoes", "vdescricaoAlteracoes"}});
        return this.toHashList(crit);
    }

    private Criteria criteria(String baseCnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria crit = this.criteria();
        crit.createAlias("repositorios", "r", JoinType.INNER_JOIN);
        crit.createAlias("r.versaosRepositorioBI", "v", JoinType.INNER_JOIN);
        crit.createAlias("classificacaoModulo", "cl", JoinType.INNER_JOIN);
        crit.createAlias("v.versaoMinimaSistema", "vm", JoinType.LEFT_OUTER_JOIN);
        crit.createAlias("clientesVinculados", "c", JoinType.LEFT_OUTER_JOIN);
        crit.add(this.eq("inativo", (short)0));
        crit.add(this.eq("v.publicado", (short)1));
        crit.add(this.eq("tipoRepositorioBI", tipo.getValue()));
        crit.add(this.or(this.eq("tipoPublicidadeBI", EnumConstBITipoPublicidade.BI_PUBLICO.getValue()), this.and(this.eq("tipoPublicidadeBI", EnumConstBITipoPublicidade.BI_PRIVADO.getValue()), this.eq("c.baseCNPJ", baseCnpj))));
        return crit;
    }
}

