/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.InfAdicionalProdImg;
import com.touchcomp.basementor.model.vo.InfAdicionalProduto;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoInfAdicionalProdutoImpl
extends DaoGenericEntityImpl<InfAdicionalProduto, Long> {
    @Override
    public InfAdicionalProduto get(Produto produto) {
        return (InfAdicionalProduto)this.toUnique(this.restrictions(this.eq("produto", produto)));
    }

    public List<InfAdicionalProduto> getAllInfo(int regsTime, int regs) {
        Criteria c = this.criteria();
        c.setMaxResults(regsTime);
        c.setFirstResult(regs);
        c.addOrder(Order.asc((String)"identificador"));
        return c.list();
    }

    public List<InfAdicionalProdImg> getAllImagens(int regsTime, int regs) {
        Criteria c = this.criteria(InfAdicionalProdImg.class);
        c.setMaxResults(regsTime);
        c.setFirstResult(regs);
        c.addOrder(Order.asc((String)"identificador"));
        return c.list();
    }

    public List<InfAdicionalProduto> getInfAdicionalProdutos(Long[] idProdutos) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jProd = builder.join("produto");
        builder.in((From)jProd, "identificador", (Number[])idProdutos);
        return builder.getResultEnt();
    }

    public InfAdicionalProduto getInfAdicionalProduto(Long idProduto) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jProd = builder.join("produto");
        builder.equal((From)jProd, "identificador", idProduto);
        return (InfAdicionalProduto)builder.getUniqueResult();
    }

    public byte[] getImagemAntiga(InfAdicionalProdImg imgInf) {
        String str = "select i.imagem from INF_ADICIONAL_PROD_IMG i where i.ID_INF_ADICIONAL_PROD_IMG=:id";
        NativeQuery sql = this.sqlQuery(str);
        sql.setParameter("id", (Object)imgInf.getIdentificador());
        List ret = sql.getResultList();
        return (byte[])ret.get(0);
    }

    public List<InfAdicionalProduto> getInfAdicionalProdutoByProduto(Long idProdutoL) {
        Criteria c = this.criteria();
        c.createAlias("produto", "prod");
        c.add(this.eq("prod.identificador", idProdutoL));
        this.orderDesc(c, "identificador");
        return c.list();
    }

    public InfAdicionalProduto findFirstInfAdicionalProdutoByProduto(Long idProdutoL) {
        Criteria c = this.criteria();
        c.createAlias("produto", "prod");
        c.add(this.eq("prod.identificador", idProdutoL));
        c.setMaxResults(1);
        return (InfAdicionalProduto)c.uniqueResult();
    }
}

