/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstGerarDocFinanceiro;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoInfPagamentoNfPropriaImp
extends DaoGenericEntityImpl<InfPagamentoNfPropria, Long> {
    public List<InfPagamentoNfPropria> getInfPagamentoNfPropriaComNumeroParcelasZerados(Empresa e, Date dataEmissao) {
        String query = "select\npg\nfrom InfPagamentoNfPropria pg\n    inner join pg.notaFiscalPropria nf\nwhere (pg.numeroParcelas = 0)\nand (cast(nf.dataEmissaoNota as date) = :dataEmissao)\nand (pg.tipoPagamentoNFe.identificador = 3 or pg.tipoPagamentoNFe.identificador = 4)and (nf.empresa.identificador = :idEmpresa)\norder by nf.numeroNota";
        org.hibernate.query.Query q = this.query(query);
        q.setDate("dataEmissao", dataEmissao);
        q.setLong("idEmpresa", e.getIdentificador().longValue());
        return this.toList((Query)q);
    }

    public List<Cliente> getClientesFatura(Date dataInicial, Date dataFinal) {
        CriteriaBuilder builder = this.criteriaBuilder(InfPagamentoNfPropria.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(InfPagamentoNfPropria.class);
        Join jNotaFiscalPropria = root.join("notaFiscalPropria", JoinType.INNER);
        Join jUnidadeFatCliente = jNotaFiscalPropria.join("unidadeFatCliente", JoinType.INNER);
        Join jCliente = jUnidadeFatCliente.join("cliente", JoinType.INNER);
        Join jMeioPagamento = root.join("meioPagamento", JoinType.INNER);
        Join jFaturaTitulosNF = root.join("faturaTitulosNF", JoinType.LEFT);
        crit.select((Selection)jCliente).distinct(true);
        exps.add(builder.between((Expression)jNotaFiscalPropria.get("dataEmissaoNota"), (Comparable)dataInicial, (Comparable)dataFinal));
        exps.add(builder.isNull((Expression)jFaturaTitulosNF.get("identificador")));
        exps.add(builder.equal((Expression)jMeioPagamento.get("gerarFinanceiro"), (Object)EnumConstGerarDocFinanceiro.GERAR_FATURA.getValue()));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<InfPagamentoNfPropria> getDadosFatNfPropria(Pessoa pessoa, Date dataInicial, Date dataFinal) {
        CriteriaBuilder builder = this.criteriaBuilder(InfPagamentoNfPropria.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(InfPagamentoNfPropria.class);
        Join jNotaFiscalPropria = root.join("notaFiscalPropria", JoinType.INNER);
        Join jUnidadeFatCliente = jNotaFiscalPropria.join("unidadeFatCliente", JoinType.INNER);
        Join jCliente = jUnidadeFatCliente.join("cliente", JoinType.INNER);
        Join jMeioPagamento = root.join("meioPagamento", JoinType.INNER);
        Join jFaturaTitulosNF = root.join("faturaTitulosNF", JoinType.LEFT);
        crit.select((Selection)root).distinct(true);
        exps.add(builder.equal((Expression)jCliente.get("pessoa"), (Object)pessoa));
        exps.add(builder.between((Expression)jNotaFiscalPropria.get("dataEmissaoNota"), (Comparable)dataInicial, (Comparable)dataFinal));
        exps.add(builder.isNull((Expression)jFaturaTitulosNF.get("identificador")));
        exps.add(builder.equal((Expression)jMeioPagamento.get("gerarFinanceiro"), (Object)EnumConstGerarDocFinanceiro.GERAR_FATURA.getValue()));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

