/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.titulo.EnumConstGerarDocFinanceiro;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoInfPagamentoNfTerceirosImpl
extends DaoGenericEntityImpl<InfPagamentoNfTerceiros, Long> {
    public List<Fornecedor> getFornecedoresFatura(Date dataInicial, Date dataFinal) {
        CriteriaBuilder builder = this.criteriaBuilder(InfPagamentoNfTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(InfPagamentoNfTerceiros.class);
        Join jNotaFiscalTerceiros = root.join("notaFiscalTerceiros", JoinType.INNER);
        Join jUnidadeFatFornecedor = jNotaFiscalTerceiros.join("unidadeFatFornecedor", JoinType.INNER);
        Join jFornecedor = jUnidadeFatFornecedor.join("fornecedor", JoinType.INNER);
        Join jMeioPagamento = root.join("meioPagamento", JoinType.INNER);
        Join jFaturaTitulosNF = root.join("faturaTitulosNF", JoinType.LEFT);
        crit.select((Selection)jFornecedor).distinct(true);
        exps.add(builder.between((Expression)jNotaFiscalTerceiros.get("dataEntrada"), (Comparable)dataInicial, (Comparable)dataFinal));
        exps.add(builder.isNull((Expression)jFaturaTitulosNF.get("identificador")));
        exps.add(builder.equal((Expression)jMeioPagamento.get("gerarFinanceiro"), (Object)EnumConstGerarDocFinanceiro.GERAR_FATURA.getValue()));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<InfPagamentoNfTerceiros> getDadosFatNfTerceiros(Pessoa pessoa, Date dataInicial, Date dataFinal) {
        CriteriaBuilder builder = this.criteriaBuilder(InfPagamentoNfTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(InfPagamentoNfTerceiros.class);
        Join jNotaFiscalTerceiros = root.join("notaFiscalTerceiros", JoinType.INNER);
        Join jUnidadeFatFornecedor = jNotaFiscalTerceiros.join("unidadeFatFornecedor", JoinType.INNER);
        Join jFornecedor = jUnidadeFatFornecedor.join("fornecedor", JoinType.INNER);
        Join jMeioPagamento = root.join("meioPagamento", JoinType.INNER);
        Join jFaturaTitulosNF = root.join("faturaTitulosNF", JoinType.LEFT);
        crit.select((Selection)root).distinct(true);
        exps.add(builder.equal((Expression)jFornecedor.get("pessoa"), (Object)pessoa));
        exps.add(builder.between((Expression)jNotaFiscalTerceiros.get("dataEntrada"), (Comparable)dataInicial, (Comparable)dataFinal));
        exps.add(builder.isNull((Expression)jFaturaTitulosNF.get("identificador")));
        exps.add(builder.equal((Expression)jMeioPagamento.get("gerarFinanceiro"), (Object)EnumConstGerarDocFinanceiro.GERAR_FATURA.getValue()));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

