/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.temp.informacoescomerciais.DTOInfoComercialProdutoRec;
import com.touchcomp.touchvomodel.temp.informacoescomerciais.DTOInfoComercialVenda;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoInformacoesComerciaisImpl
extends DaoGenericImpl {
    public DTOInfoComercialVenda getEstatisticasCliente(Long idCliente, Date dataBase) {
        String query = "select count(p.identificador) as F_ID_PEDIDO, max(p.valorTotal) as F_MAIOR_COMPRA, sum(p.valorTotal) as F_VALOR_TOTAL_COMPRAS, max(p.dataEmissao) as F_ULTIMA_COMPRA, avg(current_date - p.dataEmissao) as F_INTERVALO_MEDIO_COMPRAS, avg(p.valorTotal) as F_VALOR_MEDIO_VENDAS from Pedido p inner join p.unidadeFatCliente u inner join u.cliente c inner join p.situacaoPedido s where p.dataEmissao>=:dataBase and s.cancelarTitulos = :nao and c.identificador=:idCliente";
        Query q = this.query(query);
        q.setParameter("dataBase", (Object)dataBase);
        q.setParameter("nao", (Object)0);
        q.setParameter("idCliente", (Object)idCliente);
        q.setMaxResults(1);
        Object[] data = (Object[])q.getSingleResult();
        DTOInfoComercialVenda info = new DTOInfoComercialVenda();
        if (data != null) {
            info.setQuantidadeVendas((Long)data[0]);
            info.setMaiorVenda(ToolNumber.asZeroIfNull((Double)((Double)data[1])));
            info.setValorTotalVendas(ToolNumber.asZeroIfNull((Double)((Double)data[2])));
            info.setDataUltimaVenda((Date)data[3]);
            info.setIntervaloEntreVendas(ToolNumber.asZeroIfNull((Double)((Double)data[4])));
            info.setValorMedioVendas(ToolNumber.asZeroIfNull((Double)((Double)data[5])));
            info.setDiasDesdeUltimaVenda(Long.valueOf(ToolDate.diferenceDayBetweenDates((Date)info.getDataUltimaVenda(), (Date)new Date()).intValue()));
            info.setIdCliente(idCliente);
        }
        return info;
    }

    public List<DTOInfoComercialProdutoRec> getProdutosRecomendados(Long idCliente, Long[] idProdutosVendidos, Date dataBase, int howMany) {
        if (idProdutosVendidos.length == 0) {
            idProdutosVendidos = new Long[]{0L};
        }
        String query = "select\n   p.o_id_produto,\n   pr.codigo_auxiliar,\n   pr.nome,\n   u.sigla,\n   p.o_ultima_venda,\n   p.o_quantidade_media,\n   p.o_dias_medios_entre_vendas,\n   p.o_qtd_vendas\nfrom PROCTO_COM_AVG_VENDAS_PEDIDO(:dataBase, :idCliente) P\ninner join produto pr on pr.id_produto = p.o_id_produto\ninner join unidade_medida u on u.id_unidade_medida = pr.id_unidade_medida\nwhere pr.id_produto not in(:idProdutos) and\n      datediff(day, P.O_ULTIMA_VENDA,current_date) > P.O_DIAS_MEDIOS_ENTRE_VENDAS and\n      datediff(day, P.O_ULTIMA_VENDA,current_date) < (P.O_DIAS_MEDIOS_ENTRE_VENDAS * 5)\n      order by p.o_qtd_vendas desc ";
        NativeQuery q = this.sqlQuery(query);
        q.setDate("dataBase", dataBase);
        q.setLong("idCliente", idCliente.longValue());
        q.setParameterList("idProdutos", (Object[])idProdutosVendidos);
        q.setMaxResults(howMany);
        List data = q.getResultList();
        if (data.isEmpty()) {
            query = "select\n   p.o_id_produto,\n   pr.codigo_auxiliar,\n   pr.nome,\n   u.sigla,\n   p.o_ultima_venda,\n   p.o_quantidade_media,\n   p.o_dias_medios_entre_vendas,\n   p.o_qtd_vendas\nfrom PROCTO_COM_AVG_VENDAS_PEDIDO(:dataBase, :idCliente) P\ninner join produto pr on pr.id_produto = p.o_id_produto\ninner join unidade_medida u on u.id_unidade_medida = pr.id_unidade_medida\nwhere pr.id_produto not in(:idProdutos) and\n      datediff(day, P.O_ULTIMA_VENDA,current_date) > P.O_DIAS_MEDIOS_ENTRE_VENDAS\n      order by p.o_qtd_vendas desc ";
            q = this.sqlQuery(query);
            q.setDate("dataBase", dataBase);
            q.setLong("idCliente", idCliente.longValue());
            q.setParameterList("idProdutos", (Object[])idProdutosVendidos);
            data = q.getResultList();
        }
        LinkedList<DTOInfoComercialProdutoRec> ret = new LinkedList<DTOInfoComercialProdutoRec>();
        for (Object[] ob : data) {
            DTOInfoComercialProdutoRec d = new DTOInfoComercialProdutoRec();
            if (ob[0] != null) {
                d.setIdentificador(Long.valueOf(((Number)ob[0]).longValue()));
            }
            d.setCodigoAuxiliar((String)ob[1]);
            d.setNome((String)ob[2]);
            d.setUnidadeMedidaSigla((String)ob[3]);
            d.setDataUltVenda((Date)ob[4]);
            if (ob[5] != null) {
                d.setQtdMediaVenda(Double.valueOf(((Number)ob[5]).doubleValue()));
            }
            if (ob[6] != null) {
                d.setDiasMediosEntreCompras(Double.valueOf(((Number)ob[6]).doubleValue()));
            }
            if (ob[7] != null) {
                d.setQuantidadeVendas(Long.valueOf(((Number)ob[7]).longValue()));
            }
            d.setDiasSemCompra(Long.valueOf(TDate.difBetweenDatesInDays((Date)d.getDataUltVenda(), (Date)new Date())));
            ret.add(d);
        }
        return ret;
    }
}

