/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstFormaPagamentoBaixaTitulo;
import com.touchcomp.basementor.model.vo.IntegracaoBaixaTituloGrupoBaixaFormas;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoIntegracaoBaixaTituloGrupoBaixaFormas
extends DaoGenericEntityImpl<IntegracaoBaixaTituloGrupoBaixaFormas, Long> {
    public List<IntegracaoBaixaTituloGrupoBaixaFormas> baixasPorPeriodoPaginado(Date dataInicial, Date dataFinal, Short filtrarIdBaixa, Long idBaixa, Integer max, Integer first) {
        Object hql = "select distinct i  from IntegracaoBaixaTituloGrupoBaixaFormas i inner join i.grupoDeBaixaFormas gbf inner join gbf.grupoDeBaixa p where p.dataLiquidacao between :dataInicial and :dataFinal and gbf.formaPagamento != :formaPagamento";
        if (filtrarIdBaixa.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            hql = (String)hql + " and p.identificador = :idBaixa";
        }
        hql = (String)hql + " order by p.dataLiquidacao, p.identificador ";
        Query query = this.query((String)hql);
        query.setParameter("dataInicial", (Object)dataInicial);
        query.setParameter("dataFinal", (Object)dataFinal);
        query.setParameter("formaPagamento", (Object)EnumConstFormaPagamentoBaixaTitulo.DEVOLUCAO.getValue());
        if (filtrarIdBaixa.equals(EnumConstantsMentorSimNao.SIM.getValue())) {
            query.setParameter("idBaixa", (Object)idBaixa);
        }
        query.setMaxResults(max.intValue());
        query.setFirstResult(first.intValue());
        return query.list();
    }

    public void excluiContabilizacaoBaixaTitulosByLote(LoteContabil lote) {
        if (lote != null) {
            CriteriaBuilder criteriaBuilder = this.getSession().getCriteriaBuilder();
            CriteriaDelete query = criteriaBuilder.createCriteriaDelete(IntegracaoBaixaTituloGrupoBaixaFormas.class);
            Root root = query.from(IntegracaoBaixaTituloGrupoBaixaFormas.class);
            query.where((Expression)criteriaBuilder.equal((Expression)root.get("loteContabil"), (Object)lote));
            this.getSession().createQuery(query).executeUpdate();
        }
    }
}

