/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.controleentregaequipamento.EnumConstControleEpiTipoOperacao;
import com.touchcomp.basementor.model.vo.ItemControleEquipamento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoItemControleEquipamentoImpl
extends DaoGenericEntityImpl<ItemControleEquipamento, Long> {
    public List<ItemControleEquipamento> buscarEquipamentosVencidos(Long idColaborador, Long idEmpresaColaborador, Date dataEntrega) {
        CriteriaBuilder builder = this.criteriaBuilder(ItemControleEquipamento.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromItemControleEquipamento = crit.from(ItemControleEquipamento.class);
        Join jControleEntregaEquipamento = fromItemControleEquipamento.join("controleEntregaEquipamento", JoinType.INNER);
        Join jColaborador = jControleEntregaEquipamento.join("colaborador", JoinType.INNER);
        Join jEmpresa = jControleEntregaEquipamento.join("empresa", JoinType.INNER);
        crit.select((Selection)fromItemControleEquipamento);
        exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
        exps.add(builder.lessThanOrEqualTo((Expression)fromItemControleEquipamento.get("dataVencimento"), (Comparable)dataEntrega));
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)idEmpresaColaborador));
        Subquery subquery = crit.subquery(ItemControleEquipamento.class);
        LinkedList<Predicate> expsSub = new LinkedList<Predicate>();
        Root fromItemControleEquipamentoSub = subquery.from(ItemControleEquipamento.class);
        Join jItemControleEquipamentoAnteriorSub = fromItemControleEquipamentoSub.join("itemAnterior", JoinType.INNER);
        subquery.select((Expression)fromItemControleEquipamentoSub);
        expsSub.add(builder.equal((Expression)jItemControleEquipamentoAnteriorSub.get("identificador"), (Expression)fromItemControleEquipamento.get("identificador")));
        subquery.where(expsSub.toArray(new Predicate[0]));
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<ItemControleEquipamento> buscarEquipamentosPorColaboradorTipoOperacao(Long idColaborador, EnumConstControleEpiTipoOperacao tipoOperacao) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(ItemControleEquipamento.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromItemControleEquipamento = crit.from(ItemControleEquipamento.class);
            Join jControleEntregaEquipamento = fromItemControleEquipamento.join("controleEntregaEquipamento", JoinType.INNER);
            Join jColaborador = jControleEntregaEquipamento.join("colaborador", JoinType.INNER);
            crit.select((Selection)fromItemControleEquipamento);
            exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
            exps.add(builder.equal((Expression)jControleEntregaEquipamento.get("tipoOperacao"), (Object)tipoOperacao.getEnumId()));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception e) {
            return new ArrayList<ItemControleEquipamento>();
        }
    }
}

