/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.springframework.stereotype.Repository;

@Repository
public class DaoItemMovimentoFeriasImpl
extends DaoGenericEntityImpl<ItemMovimentoFerias, Long> {
    public List<ItemMovimentoFerias> findFeriasNaoIntegradas(Date dataInicial, Date dataFinal, Empresa empresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jFerias = aux.join("ferias");
        Join jEventoColaborador = aux.join("eventoColaborador");
        Join jTipoCalculoEvento = jEventoColaborador.join("tipoCalculoEvento");
        Join jEvento = jTipoCalculoEvento.join("evento");
        Join jColaborador = aux.join((From)jEventoColaborador, "colaborador");
        aux.where(aux.equal((From)jColaborador, "empresa", empresa), aux.between((From)jFerias, "dataGozoInicial", dataInicial, (Comparable)dataFinal), aux.getGt("valor", Integer.valueOf(0)), aux.isEmpty("itensFolhaFerias"), aux.notEqual((From)jEvento, "tipoEvento", EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue()));
        return aux.getResultEnt();
    }
}

