/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoItemMovimentoFolhaImpl
extends DaoGenericEntityImpl<ItemMovimentoFolha, Long> {
    public List<ItemMovimentoFolha> getFolhasAbertasByAberturaPeriodo(Long aberturaPeriodo) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(ItemMovimentoFolha.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromItemMovimentoFolha = crit.from(ItemMovimentoFolha.class);
            Join jMovimentoFolha = fromItemMovimentoFolha.join("movimentoFolha", JoinType.INNER);
            Join jAberturaPeriodo = jMovimentoFolha.join("aberturaPeriodo", JoinType.INNER);
            crit.select((Selection)fromItemMovimentoFolha);
            exps.add(builder.equal((Expression)jAberturaPeriodo.get("identificador"), (Object)aberturaPeriodo));
            exps.add(builder.equal((Expression)jMovimentoFolha.get("finalizado"), (Object)EnumConstantsMentorSimNao.NAO.getValue()));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception e) {
            return new ArrayList<ItemMovimentoFolha>();
        }
    }

    public List<HashMap> getItemMovimentoFolhaByAberturaPeriodoDataFinalAndTipoCalculoEventoAndEmpresa(Long tipoCalculoEvento, Long empresa, Date periodo) {
        try {
            AuxCriteriaBuilder aux = this.queryBuilder();
            Join jMovimentoFolha = aux.join("movimentoFolha");
            Join jAberturaPeriodo = jMovimentoFolha.join("aberturaPeriodo");
            Join jEventoColaborador = aux.join("eventoColaborador");
            Join jColaborador = jMovimentoFolha.join("colaborador");
            Join jPessoa = jColaborador.join("pessoa");
            Join jTipoCalculoEvento = jEventoColaborador.join("tipoCalculoEvento");
            Join jEmpresa = jMovimentoFolha.join("empresa");
            aux.select(AuxCriteriaBuilder.pair(aux.getRoot(), "valor", "valor"));
            aux.select(AuxCriteriaBuilder.pair((From)jColaborador, "identificador", "idColaborador"));
            aux.select(AuxCriteriaBuilder.pair((From)jPessoa, "nome", "nomeColaborador"));
            aux.select(AuxCriteriaBuilder.pair((From)jColaborador, "numeroRegistro", "numeroRegistro"));
            aux.equal((From)jAberturaPeriodo, "dataFinal", periodo);
            aux.equal((From)jTipoCalculoEvento, "identificador", tipoCalculoEvento);
            aux.equal((From)jEmpresa, "identificador", empresa);
            aux.orderAsc(new Expression[]{jPessoa.get("nome")});
            return aux.getResultMap();
        }
        catch (Exception e) {
            return new ArrayList<HashMap>();
        }
    }

    public List<HashMap> getItemMovimentoFolhaByAberturaPeriodoDataFinalAndTipoCalculoEventoAndTipoCalculo(Long tipoCalculoEvento, Long tipoCalculo, Date periodo) {
        try {
            AuxCriteriaBuilder aux = this.queryBuilder();
            Join jMovimentoFolha = aux.join("movimentoFolha");
            Join jAberturaPeriodo = jMovimentoFolha.join("aberturaPeriodo");
            Join jTipoCalculo = jAberturaPeriodo.join("tipoCalculo");
            Join jColaborador = jMovimentoFolha.join("colaborador");
            Join jPessoa = jColaborador.join("pessoa");
            Join jEventoColaborador = aux.join("eventoColaborador");
            Join jTipoCalculoEvento = jEventoColaborador.join("tipoCalculoEvento");
            aux.select(AuxCriteriaBuilder.pair(aux.getRoot(), "valor", "valor"));
            aux.select(AuxCriteriaBuilder.pair((From)jColaborador, "identificador", "idColaborador"));
            aux.select(AuxCriteriaBuilder.pair((From)jPessoa, "nome", "nomeColaborador"));
            aux.select(AuxCriteriaBuilder.pair((From)jColaborador, "numeroRegistro", "numeroRegistro"));
            aux.equal((From)jAberturaPeriodo, "dataFinal", periodo);
            aux.equal((From)jTipoCalculoEvento, "identificador", tipoCalculoEvento);
            aux.equal((From)jTipoCalculo, "identificador", tipoCalculo);
            return aux.getResultMap();
        }
        catch (Exception e) {
            return new ArrayList<HashMap>();
        }
    }
}

