/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLancamentoCtbGerencialImpl
extends DaoGenericEntityImpl<LancamentoCtbGerencial, Long> {
    public Double getValorUtilizadoDeOrcamento(Date dataInicial, Date dataFinal, Long idEmpresa, Long idPlanoContaGerencial, Long idCentroCusto) {
        CriteriaBuilder builder = this.criteriaBuilder(LancamentoCtbGerencial.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(LancamentoCtbGerencial.class);
        Join jPlanoContaGerencial = root.join("planoContaGerencial", JoinType.INNER);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        if (ToolMethods.isNotNull((Object)idCentroCusto).booleanValue() && !ToolMethods.isEquals((Object)idCentroCusto, (Object)0L)) {
            Join jCentroCusto = root.join("centroCusto", JoinType.INNER);
            exps.add(builder.equal((Expression)jCentroCusto.get("identificador"), (Object)idCentroCusto));
        }
        crit.select((Selection)builder.sum((Expression)root.get("valor")));
        exps.add(builder.equal((Expression)jPlanoContaGerencial.get("identificador"), (Object)idPlanoContaGerencial));
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)idEmpresa));
        exps.add(builder.between((Expression)root.get("dataCadastro"), (Comparable)dataInicial, (Comparable)dataFinal));
        exps.add(builder.equal((Expression)root.get("tipoLancamento"), (Object)EnumConstantsMentorSimNao.NAO.getValue()));
        exps.add(builder.equal((Expression)root.get("provRealizado"), (Object)EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue()));
        crit.where(exps.toArray(new Predicate[0]));
        Object result = this.getEntityManager().createQuery(crit).getSingleResult();
        return ToolMethods.isNotNull((Object)result) != false ? (Double)result : 0.0;
    }
}

