/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LancamentoSpedPisCofins;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLancamentoSpedPisCofinsImpl
extends DaoGenericEntityImpl<LancamentoSpedPisCofins, Long> {
    public List<ItemNotaTerceiros> gerarLancOutrosCredF100Terc(Date dataIn, Date dataFinal, GrupoEmpresa grupo) {
        String query = "select distinct item from ItemNotaTerceiros item inner join item.modeloFiscal m inner join m.modeloFiscalPisCofins mp inner join mp.modeloPisCofinsF100 mf100 inner join item.notaFiscalTerceiros n inner join n.empresa e inner join e.empresaDados ed left join LancamentoSpedPisCofins l on (l.itemNotaOrigemTerc=item) where ed.grupoEmpresa=:grupoEmpresa and n.dataEntrada between :dataIn and :dataFim and mf100.gerarRegF100=:sim and l.identificador is null";
        Query q = this.query(query);
        q.setEntity("grupoEmpresa", (Object)grupo);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFinal);
        q.setShort("sim", (short)1);
        return q.list();
    }

    public List<ItemNotaFiscalPropria> gerarLancOutrosCredF100Prop(Date dataIn, Date dataFinal, GrupoEmpresa grupo) {
        String query = "select distinct item from ItemNotaFiscalPropria item inner join item.modeloFiscal m inner join m.modeloFiscalPisCofins mp inner join mp.modeloPisCofinsF100 mf100 inner join item.notaFiscalPropria n inner join n.naturezaOperacao nat inner join n.empresa e inner join e.empresaDados ed left join LancamentoSpedPisCofins l on (l.itemNotaOrigemProp=item) where ed.grupoEmpresa=:grupoEmpresa and cast(n.dataEmissaoNota as date) between :dataIn and :dataFim and mf100.gerarRegF100=:sim and (n.status=:autorizada or n.status=:autorizadaFora) and l.identificador is null";
        Query q = this.query(query);
        q.setEntity("grupoEmpresa", (Object)grupo);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFinal);
        q.setShort("sim", (short)1);
        q.setShort("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().shortValue());
        q.setShort("autorizadaFora", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().shortValue());
        return q.list();
    }

    public List<BaixaTitulo> gerarLancOutrosCredF100Baixas(Date dataIn, Date dataFinal, GrupoEmpresa grupo) {
        String query = "select distinct baixa from BaixaTitulo baixa inner join baixa.grupoDeBaixaFormas gf inner join gf.grupoDeBaixa g inner join baixa.titulo t inner join baixa.lancamentoPisCofins l inner join t.tipoDoc t inner join t.empresa e inner join e.empresaDados ed where ed.grupoEmpresa=:grupoEmpresa and cast(g.dataLiquidacao as date) between :dataIn and :dataFim and t.gerarLancamentoPisCofins=:sim and l.identificador is null";
        Query q = this.query(query);
        q.setEntity("grupoEmpresa", (Object)grupo);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFinal);
        q.setShort("sim", (short)1);
        return q.list();
    }

    public List<Lancamento> gerarLancOutrosCredF100Lanc(Date dataIn, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        String query = "select distinct l  FROM Lancamento l where l.grupoEmpresa = :grupoEmpresa and cast(l.dataLancamento as date) between :dataIn and :dataFim and not exists (SELECT a.identificador FROM LancamentoSpedPisCofins a WHERE a.lancamento = l)";
        Query q = this.query(query);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setDate("dataIn", dataIn);
        q.setDate("dataFim", dataFinal);
        return q.list();
    }
}

