/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.DTOLeadTimeSimples;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLeadTimeFornProduto
extends DaoGenericEntityImpl<LeadTimeFornProduto, Long> {
    public List<LeadTimeFornProduto> findLeadTimeGradeCorHomologado(GradeCor gradeCor, Empresa empresa, Short filtrarHomologados) {
        Criteria criteria = this.criteria();
        criteria.add(this.eq("gradeCor", gradeCor));
        if (TMethods.isAffirmative((Number)filtrarHomologados)) {
            criteria.add(this.eq("homologado", EnumConstantsMentorSimNao.SIM.getValue()));
        }
        criteria.createAlias("leadTimeFornecedor", "lf");
        criteria.createAlias("lf.leadTimeFornEmpresa", "le");
        criteria.add(this.eq("le.empresa", empresa));
        return criteria.list();
    }

    public boolean isAquisicaoPreferencial(Long idUnidadeFatForn, Long idGradeCor, Long idEmpresa) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jLeadGradeCor = builder.join("gradeCor");
        Join jLeadTime = builder.join("leadTimeFornecedor");
        Join jEmpresas = builder.join((From)jLeadTime, "leadTimeFornEmpresa");
        Join jLeadUnidadeFat = builder.join((From)jLeadTime, "unidadeFatFornecedor");
        Join jLeadEmpresa = builder.join((From)jEmpresas, "empresa");
        builder.equal((From)jLeadUnidadeFat, "identificador", idUnidadeFatForn);
        builder.equal((From)jLeadEmpresa, "identificador", idEmpresa);
        builder.equal((From)jLeadGradeCor, "identificador", idGradeCor);
        builder.equal("aquisicaoPreferencial", EnumConstantsMentorSimNao.SIM.getValue());
        builder.select(builder.getCount("identificador"));
        Number nr = (Number)builder.getUniqueGenericResult();
        return nr != null && nr.longValue() > 0L;
    }

    public List<DTOLeadTimeSimples> getLeadsTimeAssociadosCotacao(Long idCotacao) {
        String quuery = "select \n lg.gradeCor.identificador as F_ID_GRADE_COR,\n le.empresa.identificador as F_ID_EMPRESA,\n l.unidadeFatFornecedor.identificador as F_ID_UNIDADE_FAT_FON,\n lg.aquisicaoPreferencial as F_AQUISICAO_PREF,\n lg.leadTime as F_LEAD_TIME\n  from CotacaoCompra c\n inner join c.itensCotacaoCompra i\n inner join i.fornecedoresItemCotacaoCompra f\n inner join LeadTimeFornecedor l on l.unidadeFatFornecedor=f.unidadeFaturamentoFornecedor\n inner join l.leadTimeFornEmpresa le on le.empresa=c.empresa\n inner join l.leadTimeFornProduto lg on lg.gradeCor=i.gradeCor\n where c.identificador=:idCotacaoCompra\n";
        Query q = this.query(quuery).setLong("idCotacaoCompra", idCotacao.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List data = q.list();
        LinkedList<DTOLeadTimeSimples> aux = new LinkedList<DTOLeadTimeSimples>();
        for (Map map : data) {
            DTOLeadTimeSimples dto = new DTOLeadTimeSimples();
            dto.setAquisicaoPreferencial((short)Short.MIN_VALUE);
            dto.setIdEmpresa((Long)map.get("F_ID_EMPRESA"));
            dto.setIdGradeCor((Long)map.get("F_ID_GRADE_COR"));
            dto.setIdUnidadeFatFornecedor((Long)map.get("F_ID_UNIDADE_FAT_FON"));
            dto.setAquisicaoPreferencial((Short)map.get("F_AQUISICAO_PREF"));
            dto.setLeadTime((Integer)map.get("F_LEAD_TIME"));
            aux.add(dto);
        }
        return aux;
    }
}

