/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.LeadTimeFornecedorAval;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLeadTimeFornecedorAvalImpl
extends DaoGenericEntityImpl<LeadTimeFornecedorAval, Long> {
    public List<LeadTimeFornecedorAval> getAll(UnidadeFatFornecedor un) {
        return this.toList(this.restrictions(this.eq("unidadeFatFornecedor", un)));
    }

    public List<LeadTimeFornecedorAval> getAllId(Long idUnidade) {
        return this.toList(this.restrictions(this.eq("unidadeFatFornecedor.identificador", idUnidade)));
    }

    public Double getEficiencia(UnidadeFatFornecedor unidadeFatFornecedor) {
        org.hibernate.query.Query q = this.query("select sum(l.pontuacaoAlcancada) as PONTUACAO_ALCANCADA,sum(l.pontuacaoMaxima) AS PONTUACAO_MAXIMA  from LeadTimeFornecedorAval l  where l.unidadeFatFornecedor = :unidadeFatFornecedor");
        q.setEntity("unidadeFatFornecedor", (Object)unidadeFatFornecedor);
        Map<String, Object> res = this.toHashUnique((Query)q);
        if (res == null) {
            return 0.0;
        }
        Double pontAlcancada = (Double)res.get("PONTUACAO_ALCANCADA");
        Double pontMaxima = (Double)res.get("PONTUACAO_MAXIMA");
        return pontAlcancada != null && pontMaxima != null && pontMaxima > 0.0 ? pontAlcancada / pontMaxima * 100.0 : 0.0;
    }

    public Double getEficienciaFornecedor(Long idUnidadeFatFornecedor) {
        org.hibernate.query.Query q = this.query("select sum(l.pontuacaoAlcancada) as PONTUACAO_ALCANCADA,sum(l.pontuacaoMaxima) AS PONTUACAO_MAXIMA  from LeadTimeFornecedorAval l  where l.unidadeFatFornecedor.identificador = :unidadeFatFornecedor");
        q.setLong("unidadeFatFornecedor", idUnidadeFatFornecedor.longValue());
        Map<String, Object> res = this.toHashUnique((Query)q);
        if (res == null) {
            return 0.0;
        }
        Double pontAlcancada = (Double)res.get("PONTUACAO_ALCANCADA");
        Double pontMaxima = (Double)res.get("PONTUACAO_MAXIMA");
        return pontAlcancada != null && pontMaxima != null && pontMaxima > 0.0 ? pontAlcancada / pontMaxima * 100.0 : 0.0;
    }
}

