/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.ordemcompra.EnumConstOrdemCompraStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemConfLibOCClassificacao;
import com.touchcomp.basementor.model.vo.ItemConfLibOCUsuValor;
import com.touchcomp.basementor.model.vo.ItemConfLibUsuOCEspecie;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompraItem;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLiberacaoOrdemCompraItemImpl
extends DaoGenericEntityImpl<LiberacaoOrdemCompraItem, Long> {
    public List<LiberacaoOrdemCompraItem> getOrdensCompraConfConfigLibClassificacao(List<ItemConfLibOCClassificacao> itens, Empresa empresa, Usuario usuario) {
        Criteria c = this.criteria();
        c.createAlias("liberacaoOrdemCompra", "lib", JoinType.INNER_JOIN);
        c.createAlias("lib.ordemCompra", "oc", JoinType.INNER_JOIN);
        c.createAlias("oc.itemOrdemCompra", "item", JoinType.INNER_JOIN);
        c.createAlias("oc.statusOrdemCompra", "s", JoinType.INNER_JOIN);
        this.restrictions(c, this.eq("s.status", EnumConstOrdemCompraStatus.ABERTO.value));
        this.restrictions(c, this.eq("oc.empresa", empresa));
        this.restrictions(c, this.eq("liberado", EnumConstantsMentorSimNao.NAO.value));
        Disjunction d = Restrictions.disjunction();
        itens.forEach(i -> {
            Conjunction conj = Restrictions.conjunction();
            conj.add(this.eq("classificacaoOrdemCompra", i.getClassificacaoOC()));
            conj.add(this.between("valor", i.getValorMinimo(), i.getValorMaximo()));
            d.add((Criterion)conj);
        });
        c.add((Criterion)d);
        DetachedCriteria subquery = DetachedCriteria.forClass(LiberacaoOrdemCompraItem.class, (String)"sub");
        subquery.createAlias("sub.liberacaoOrdemCompra", "loc");
        subquery.createAlias("loc.ordemCompra", "ordem");
        subquery.createAlias("sub.usuario", "us");
        subquery.add((Criterion)Property.forName((String)"ordem.identificador").eqProperty("oc.identificador"));
        subquery.add((Criterion)Restrictions.eq((String)"us.identificador", (Object)usuario.getIdentificador()));
        subquery.add((Criterion)Restrictions.eq((String)"loc.liberado", (Object)EnumConstantsMentorSimNao.SIM.value));
        subquery.setProjection((Projection)Projections.property((String)"sub.identificador"));
        c.add(Subqueries.notExists((DetachedCriteria)subquery));
        ProjectionList p = Projections.projectionList();
        p.add((Projection)Projections.property((String)"identificador"));
        c.setProjection((Projection)p);
        List ids = c.list();
        LinkedList<LiberacaoOrdemCompraItem> res = new LinkedList<LiberacaoOrdemCompraItem>();
        for (Long re : ids) {
            if (this.existeIdOrdemCompra(re, res)) continue;
            res.add((LiberacaoOrdemCompraItem)this.get(re));
        }
        return res;
    }

    public List<LiberacaoOrdemCompraItem> getOrdensCompraConfConfigLibEspecie(List<ItemConfLibUsuOCEspecie> especies, Empresa empresa, Usuario usuario) {
        Criteria c = this.criteria();
        c.createAlias("liberacaoOrdemCompra", "lib", JoinType.INNER_JOIN);
        c.createAlias("lib.ordemCompra", "oc", JoinType.INNER_JOIN);
        c.createAlias("oc.itemOrdemCompra", "item", JoinType.INNER_JOIN);
        c.createAlias("oc.statusOrdemCompra", "s", JoinType.INNER_JOIN);
        this.restrictions(c, this.notEqual("s.status", EnumConstOrdemCompraStatus.FECHADA.value));
        this.restrictions(c, this.notEqual("s.status", EnumConstOrdemCompraStatus.CANCELADO.value));
        this.restrictions(c, this.eq("oc.empresa", empresa));
        this.restrictions(c, this.eq("liberado", EnumConstantsMentorSimNao.NAO.value));
        Disjunction d = Restrictions.disjunction();
        especies.forEach(i -> {
            Conjunction conj = Restrictions.conjunction();
            conj.add(this.eq("especie", i.getEspecie()));
            conj.add(this.between("valor", i.getValorMinimo(), i.getValorMaximo()));
            d.add((Criterion)conj);
        });
        DetachedCriteria subquery = DetachedCriteria.forClass(LiberacaoOrdemCompraItem.class, (String)"sub");
        subquery.createAlias("sub.liberacaoOrdemCompra", "loc");
        subquery.createAlias("loc.ordemCompra", "ordem");
        subquery.createAlias("sub.usuario", "us");
        subquery.add((Criterion)Property.forName((String)"ordem.identificador").eqProperty("oc.identificador"));
        subquery.add((Criterion)Restrictions.eq((String)"us.identificador", (Object)usuario.getIdentificador()));
        subquery.add((Criterion)Restrictions.eq((String)"loc.liberado", (Object)EnumConstantsMentorSimNao.SIM.value));
        subquery.setProjection((Projection)Projections.property((String)"sub.identificador"));
        c.add(Subqueries.notExists((DetachedCriteria)subquery));
        c.add((Criterion)d);
        c.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return c.list();
    }

    public List<LiberacaoOrdemCompraItem> getOrdensCompraConfConfigLibValor(ItemConfLibOCUsuValor user, Empresa empresa, Usuario usuario) {
        Criteria c = this.criteria();
        c.createAlias("liberacaoOrdemCompra", "lib");
        c.createAlias("lib.ordemCompra", "oc");
        c.createAlias("oc.itemOrdemCompra", "item");
        c.createAlias("oc.statusOrdemCompra", "s");
        this.restrictions(c, this.notEqual("s.status", EnumConstOrdemCompraStatus.FECHADA.value));
        this.restrictions(c, this.notEqual("s.status", EnumConstOrdemCompraStatus.CANCELADO.value));
        this.restrictions(c, this.eq("oc.empresa", empresa));
        this.restrictions(c, this.eq("liberado", EnumConstantsMentorSimNao.NAO.value));
        this.restrictions(c, this.between("valor", user.getValorMinimo(), user.getValorMaximo()));
        DetachedCriteria subquery = DetachedCriteria.forClass(LiberacaoOrdemCompraItem.class, (String)"sub");
        subquery.createAlias("sub.liberacaoOrdemCompra", "loc");
        subquery.createAlias("loc.ordemCompra", "ordem");
        subquery.createAlias("sub.usuario", "us");
        subquery.add((Criterion)Property.forName((String)"ordem.identificador").eqProperty("oc.identificador"));
        subquery.add((Criterion)Restrictions.eq((String)"us.identificador", (Object)usuario.getIdentificador()));
        subquery.add((Criterion)Restrictions.eq((String)"loc.liberado", (Object)EnumConstantsMentorSimNao.SIM.value));
        subquery.setProjection((Projection)Projections.property((String)"sub.identificador"));
        c.add(Subqueries.notExists((DetachedCriteria)subquery));
        c.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return c.list();
    }

    private boolean existeIdOrdemCompra(Long re, List<LiberacaoOrdemCompraItem> res) {
        for (LiberacaoOrdemCompraItem i : res) {
            if (!i.getIdentificador().equals(re)) continue;
            return true;
        }
        return false;
    }
}

