/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.constants.enums.ticketfiscal.EnumConstTicketFiscalStatus;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorservice.model.movimentoprodutos.RazaoAnalitico;
import com.touchcomp.basementorservice.service.impl.movimentoprodutos.ServiceMovimentoProdutosImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoListagemMovimentoProdutosImpl
extends DaoGenericImpl {
    public Collection getMovimentosNFPropriaRelMovProd(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select (cast(g.quantidade as double)) as QUANTIDADE, (cast(g.fatorConversao as double)) as FATOR_CONVERSAO, gc.identificador as ID_GRADE_COR, cc.nome as GRADE_COR, g.movimentacaoFisica as MOVIMENTACAO_FISICA, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, pr.codigoAuxiliar as COD_AUXILIAR, unid.sigla as UNIDADE_MEDIDA, g.entradaSaida AS ENTRADA_SAIDA, i.vrProduto AS VALOR_CUSTO, g.valorCusto as VALOR_CUSTO_ENTRADA, g.dataEntradaSaida as DATA_MOVIMENTO,  lt.loteFabricacao as LOTE_FABRICACAO, np.serie as SERIE,np.numeroNota as NUMERO_NOTA, cli.identificador as ID_CLIENTE, pesCli.nome as NOME_CLIENTE, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE from GradeItemNotaFiscalPropria g inner join g.gradeCor gc inner join gc.produtoGrade pg left join g.itemNotaFiscalPropria i left join i.notaFiscalPropria np left join np.situacaoDocumento st left join np.unidadeFatCliente unC left join unC.cliente cli left join cli.pessoa pesCli left join np.naturezaOperacao nat left join pg.produto pr left join pr.especie esp left join pr.subEspecie sub left join pr.unidadeMedida unid left join gc.cor cc left join g.loteFabricacao lt left join g.centroEstoque ce where      (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and (:filtrarGradeCor <> 1 or g.gradeCor.identificador between :idGradeCorInicial and :idGradeCorFinal) and g.dataEntradaSaida between :dataIn and :dataFim and g.empresa=:empresa and (:filtrarLote <> 1 or lt.identificador = :idLote)  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal) and (:movimentaEstoque = 2 or g.movimentacaoFisica = :movimentaEstoque) ";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        if (!ToolMethods.isAffirmative((Number)params.getMovimentaEstoque())) {
            hql = (String)hql + " and st.codigo not in (:codCancelados) ";
        }
        hql = (String)hql + " order by pr.identificador, g.dataEntradaSaida, g.entradaSaida";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("movimentaEstoque", (Object)ToolMethods.isNulThen0((Number)params.getMovimentaEstoque(), Integer.class));
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        if (!ToolMethods.isAffirmative((Number)params.getMovimentaEstoque())) {
            q.setParameter("codCancelados", (Object)EnumConstSituacaoDocumento.getSituacoesInvalidasStr());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            if (ToolMethods.isAffirmative((Number)params.getExibirNomeClienteForne())) {
                rz.setDescricao("NF. Pr\u00f3pria: " + String.valueOf(h.get("SERIE")) + "/" + String.valueOf(h.get("NUMERO_NOTA")) + " - " + String.valueOf(h.get("ID_CLIENTE")) + " - " + String.valueOf(h.get("NOME_CLIENTE")));
            } else {
                rz.setDescricao("NF. Pr\u00f3pria: " + String.valueOf(h.get("SERIE")) + "/" + String.valueOf(h.get("NUMERO_NOTA")) + " - " + String.valueOf(h.get("ID_CLIENTE")));
            }
            if ((Short)h.get("ENTRADA_SAIDA") == 0 || (Short)h.get("ENTRADA_SAIDA") == 2) {
                rz.setEntradaSaida((short)0);
                rz.setValorUnitario((Double)h.get("VALOR_CUSTO_ENTRADA"));
                Double quantidade = ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6);
                Double fatorConversao = ToolFormatter.arrredondarNumero((Double)((Double)h.get("FATOR_CONVERSAO")), (int)6);
                rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)(quantidade * fatorConversao), (int)6));
            } else {
                rz.setEntradaSaida((short)1);
                rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            }
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            rz.setMovimentacaoFisica((Short)h.get("MOVIMENTACAO_FISICA"));
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getMovimentosComunicadoProducao(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select (g.quantidade) as QUANTIDADE, gc.identificador as ID_GRADE_COR, c.nome as GRADE_COR, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, pr.codigoAuxiliar as COD_AUXILIAR, un.sigla as UNIDADE_MEDIDA, g.valorUnitario AS VALOR_CUSTO, g.dataMovimentacao as DATA_MOVIMENTO,  l.loteFabricacao as LOTE_FABRICACAO, np.identificador as ID_COMUNICADO, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE, evt.identificador as ID_EVENTO, s.nrOrdem as SUBCODIGO, os.codigo as CODIGO from GradeItemComunicadoProducao g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto pr inner join pr.unidadeMedida un left join pr.especie esp left join pr.subEspecie sub left join g.loteFabricacao l left join g.itemComunicadoProducao i left join i.centroCusto cc left join i.comunicadoProducao np left join np.eventoOsProducao evt left join evt.subdivisaoOSProd s left join s.ordemServicoProdLinhaProd os left join g.centroEstoque ce where  (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and (:filtrarGradeCor <> 1 or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and   g.dataMovimentacao between :dataIn and :dataFim and (:filtrarLote <> 1 or l.identificador = :idLote)  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal)  and g.empresa=:empresa  and g.quantidade > 0  and (:filtrarCentroCusto = 0 or cc.identificador = :idCentroCusto)";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        hql = (String)hql + " order by pr.identificador, g.dataMovimentacao";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        q.setParameter("filtrarCentroCusto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroCusto(), Integer.class));
        q.setParameter("idCentroCusto", (Object)params.getIdCentroCusto());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            rz.setDescricao("CP ID/Evt/OS-SUBOS: " + String.valueOf(h.get("ID_COMUNICADO")));
            if (h.get("ID_EVENTO") != null) {
                rz.setDescricao(rz.getDescricao() + "/" + String.valueOf(h.get("ID_EVENTO")));
                rz.setDescricao(rz.getDescricao() + "/" + String.valueOf(h.get("CODIGO")));
                rz.setDescricao(rz.getDescricao() + "-" + String.valueOf(h.get("SUBCODIGO")));
            }
            rz.setEntradaSaida((short)0);
            rz.setMovimentacaoFisica(EnumConstantsMentorSimNao.SIM.getValue());
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setValorUnitario((Double)h.get("VALOR_CUSTO"));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getMovimentosImplantacaoSaldo(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select g.quantidade as QUANTIDADE, gc.identificador as ID_GRADE_COR, c.nome as GRADE_COR, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, pr.codigoAuxiliar as COD_AUXILIAR, un.sigla as UNIDADE_MEDIDA, g.valorUnitario AS VALOR_CUSTO, g.dataMovimentacao as DATA_MOVIMENTO,  l.loteFabricacao as LOTE_FABRICACAO, np.identificador as ID_IMPLANTA, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE from GradeItemImpSaldo g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto pr inner join pr.unidadeMedida un left join pr.especie esp left join pr.subEspecie sub left join g.loteFabricacao l left join g.itemImplantaSaldo i left join i.implantacaoSaldos np left join g.centroEstoque ce where  (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal)  and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and (:filtrarGradeCor <> 1   or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and g.dataMovimentacao between :dataIn and :dataFim  and g.empresa=:empresa  and g.quantidade > 0  and (:filtrarLote <> 1 or l.identificador = :idLote)  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal) ";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        hql = (String)hql + " order by pr.identificador, g.dataMovimentacao";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            rz.setDescricao("Imp. Saldo: " + String.valueOf(h.get("ID_IMPLANTA")));
            rz.setEntradaSaida((short)0);
            rz.setMovimentacaoFisica(EnumConstantsMentorSimNao.SIM.getValue());
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setValorUnitario((Double)h.get("VALOR_CUSTO"));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getMovimentosNFTerceirosRelMovProd(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select (cast(g.quantidade as double) * cast(g.fatorConversao as double)) as QUANTIDADE, gc.identificador as ID_GRADE_COR, g.movimentacaoFisica as MOVIMENTACAO_FISICA, c.nome as GRADE_COR, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, pr.codigoAuxiliar as COD_AUXILIAR, un.sigla as UNIDADE_MEDIDA, g.valorCusto AS VALOR_CUSTO, g.dataEntradaSaida as DATA_MOVIMENTO,  l.loteFabricacao as LOTE_FABRICACAO, np.serie as SERIE,np.numeroNota as NUMERO_NOTA, f.identificador as ID_FORNECEDOR, ps.nome as NOME_FORNECEDOR, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE from GradeItemNotaTerceiros g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto pr inner join pr.unidadeMedida un left join g.loteFabricacao l left join pr.especie esp left join pr.subEspecie sub left join g.itemNotaTerceiros i left join i.centroCusto cc left join i.notaFiscalTerceiros np left join np.unidadeFatFornecedor unf left join unf.fornecedor f left join f.pessoa ps left join g.centroEstoque ce where    (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and (:filtrarGradeCor <> 1 or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and g.dataEntradaSaida between :dataIn and :dataFim and g.empresa=:empresa and (:filtrarLote <> 1 or g.loteFabricacao.identificador = :idLote)  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal)  and (:movimentaEstoque = 2 or g.movimentacaoFisica = :movimentaEstoque)  and (:filtrarCentroCusto = 0 or cc.identificador = :idCentroCusto)";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        hql = (String)hql + " order by pr.identificador, g.dataEntradaSaida";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("movimentaEstoque", (Object)ToolMethods.isNulThen((Number)params.getMovimentaEstoque(), (Integer)2));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setShort("tipoCentroEstoque", params.getTipoCentroEstoque().shortValue());
        }
        q.setParameter("filtrarCentroCusto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroCusto(), Integer.class));
        q.setParameter("idCentroCusto", (Object)params.getIdCentroCusto());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            if (TMethods.isAffirmative((Number)params.getExibirNomeClienteForne())) {
                rz.setDescricao("NF. Terceiros: " + String.valueOf(h.get("SERIE")) + "/" + String.valueOf(h.get("NUMERO_NOTA")) + " - " + String.valueOf(h.get("ID_FORNECEDOR")) + " - " + String.valueOf(h.get("NOME_FORNECEDOR")));
            } else {
                rz.setDescricao("NF. Terceiros: " + String.valueOf(h.get("SERIE")) + "/" + String.valueOf(h.get("NUMERO_NOTA")) + " - " + String.valueOf(h.get("ID_FORNECEDOR")));
            }
            rz.setEntradaSaida((short)0);
            rz.setMovimentacaoFisica((Short)h.get("MOVIMENTACAO_FISICA"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setValorUnitario((Double)h.get("VALOR_CUSTO"));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getMovimentosRequisicao(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select  cc.codigo        as CODIGO_CENTRO_CUSTO,  cc.nome         as DESC_CENTRO_CUSTO,  (g.quantidade)                  as QUANTIDADE,  gc.identificador        as ID_GRADE_COR,  c.nome             as GRADE_COR,  pr.identificador         as ID_PRODUTO,  pr.nome                  as NOME_PRODUTO,  esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, pr.codigoAuxiliar        as COD_AUXILIAR,  un.sigla   as UNIDADE_MEDIDA,  g.dataMovimentacao               as DATA_MOVIMENTO,  l.loteFabricacao as LOTE_FABRICACAO, np.identificador                as ID_REQUISICAO, ce.identificador   as ID_CENTRO_ESTOQUE, ce.descricao       as CENTRO_ESTOQUE, evt.identificador as ID_EVENTO, s.nrOrdem as SUBCODIGO, os.codigo as CODIGO from GradeItemRequisicao g inner join g.centroEstoque ce inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto pr inner join pr.unidadeMedida un left join pr.especie esp left join pr.subEspecie sub left join g.loteFabricacao l left join g.itemRequisicao i left join i.requisicao np left join i.centroCusto cc left join np.eventoOsProducaoLinhaProd evt left join evt.subdivisaoOSProd s left join s.ordemServicoProdLinhaProd os where  (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and (:filtrarGradeCor <> 1 or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and g.dataMovimentacao between :dataIn and :dataFim and g.empresa=:empresa  and g.quantidade > 0  and (:filtrarLote <> 1 or l.identificador = :idLote)  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal)  and (:filtrarCentroCusto = 0 or cc.identificador = :idCentroCusto)";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        hql = (String)hql + " order by pr.identificador, g.dataMovimentacao ";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        q.setParameter("filtrarCentroCusto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroCusto(), Integer.class));
        q.setParameter("idCentroCusto", (Object)params.getIdCentroCusto());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        String centroCusto = " ";
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            centroCusto = ToolMethods.isAffirmative((Number)params.getExibirNomeClienteForne()) ? (String)h.get("DESC_CENTRO_CUSTO") : (String)h.get("CODIGO_CENTRO_CUSTO");
            rz.setDescricao("Req. ID/CC/Evt/OS-SUBOS: " + String.valueOf(h.get("ID_REQUISICAO")) + "/" + centroCusto);
            if (h.get("ID_EVENTO") != null) {
                rz.setDescricao(rz.getDescricao() + "/" + String.valueOf(h.get("ID_EVENTO")));
                rz.setDescricao(rz.getDescricao() + "/" + String.valueOf(h.get("CODIGO")));
                rz.setDescricao(rz.getDescricao() + "-" + String.valueOf(h.get("SUBCODIGO")));
            }
            rz.setValorUnitario(0.0);
            rz.setEntradaSaida((short)1);
            rz.setMovimentacaoFisica(EnumConstantsMentorSimNao.SIM.getValue());
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getMovimentosTransfEstOrigem(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select (g.quantidade) as QUANTIDADE, gc.identificador as ID_GRADE_COR, c.nome as GRADE_COR, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, pr.codigoAuxiliar as COD_AUXILIAR, un.sigla as UNIDADE_MEDIDA, g.dataTransferencia as DATA_MOVIMENTO,  l.loteFabricacao as LOTE_FABRICACAO, t.identificador as ID_TRANSFERENCIA, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE, p.identificador as ID_PEDIDO_TRANSFERENCIA from GradeItemTransfCentroEstoque g inner join g.gradeCor gc  inner join gc.cor c  inner join gc.produtoGrade pg  inner join pg.produto pr  inner join pr.unidadeMedida un  inner join pr.especie esp  inner join pr.subEspecie sub  left join g.itemTransfCentroEst i  left join i.transfCentroEstoque t  left join g.origem ce left  join t.pedido p left  join g.loteFabricacao l where  (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and (:filtrarGradeCor <> 1 or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and g.dataTransferencia between :dataIn and :dataFim and g.empresa=:empresa  and (:filtrarLote <> 1 or l.identificador = :idLote)  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal) ";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        hql = (String)hql + " order by pr.identificador, g.dataTransferencia";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            rz.setDescricao("Transf. Estoque: " + String.valueOf(h.get("ID_TRANSFERENCIA")) + (String)(h.get("ID_PEDIDO_TRANSFERENCIA") != null ? " - Pedido: " + String.valueOf(h.get("ID_PEDIDO_TRANSFERENCIA")) : ""));
            rz.setValorUnitario(0.0);
            rz.setEntradaSaida((short)1);
            rz.setMovimentacaoFisica(EnumConstantsMentorSimNao.SIM.getValue());
            rz.setTipoMovimento(6);
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getMovimentosTransfEstDestino(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select (g.quantidade) as QUANTIDADE, gc.identificador as ID_GRADE_COR, c.nome as GRADE_COR, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, pr.codigoAuxiliar as COD_AUXILIAR, un.sigla as UNIDADE_MEDIDA, g.dataTransferencia as DATA_MOVIMENTO,  l.loteFabricacao as LOTE_FABRICACAO, t.identificador as ID_TRANSFERENCIA, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE, p.identificador as ID_PEDIDO_TRANSFERENCIA from GradeItemTransfCentroEstoque g inner join g.gradeCor gc  inner join gc.cor c  inner join gc.produtoGrade pg  inner join pg.produto pr  inner join pr.unidadeMedida un  inner join pr.especie esp  inner join pr.subEspecie sub  left join g.loteFabricacao l left join g.itemTransfCentroEst i  left join i.transfCentroEstoque t  left join g.destino ce left  join t.pedido p where  (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and (:filtrarGradeCor <> 1 or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and g.dataTransferencia between :dataIn and :dataFim and g.empresa=:empresa  and g.quantidade > 0  and (:filtrarLote <> 1 or l.identificador = :idLote)  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal) ";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        hql = (String)hql + " order by pr.identificador, g.dataTransferencia";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            rz.setDescricao("Transf. Estoque: " + String.valueOf(h.get("ID_TRANSFERENCIA")) + (String)(h.get("ID_PEDIDO_TRANSFERENCIA") != null ? " - Pedido: " + String.valueOf(h.get("ID_PEDIDO_TRANSFERENCIA")) : ""));
            rz.setValorUnitario(0.0);
            rz.setEntradaSaida((short)0);
            rz.setMovimentacaoFisica(EnumConstantsMentorSimNao.SIM.getValue());
            rz.setTipoMovimento(6);
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getMovimentosPedComercio(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select i.quantidadeTotal as QUANTIDADE, gc.identificador as ID_GRADE_COR, c.nome as GRADE_COR, i.movimentarEstoque as MOVIMENTACAO_FISICA, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, pr.codigoAuxiliar as COD_AUXILIAR, un.sigla as UNIDADE_MEDIDA, 1 AS ENTRADA_SAIDA, 0 AS VALOR_CUSTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, i.dataMovimentacao as DATA_MOVIMENTO,  l.loteFabricacao as LOTE_FABRICACAO, cl.identificador as ID_CLIENTE, p.identificador as ID_PEDIDO_COMERCIO, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE from ItemPedidoComercio i inner join i.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto pr left join pr.unidadeMedida un left join pr.especie esp left join pr.subEspecie sub left join i.pedidoComercio p left join i.centroEstoque ce left  join i.loteFabricacao l left  join p.cliente cl where   (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and cast(i.dataMovimentacao as date) between :dataIn and :dataFim and (:filtrarGradeCor <> 1 or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and i.empresa=:empresa and (:filtrarLote <> 1 or l.identificador = :idLote)  and i.quantidadeTotal > 0  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal)  and (:movimentaEstoque = 2 or i.movimentarEstoque = :movimentaEstoque) ";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        if (!ToolMethods.isAffirmative((Number)params.getMovimentaEstoque())) {
            hql = (String)hql + " and i.itemCancelado != :cancelado ";
        }
        hql = (String)hql + " order by pr.identificador, i.dataMovimentacao";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarCentro", (Object)(params.getIdCentroEstInicial() != null && params.getIdCentroEstFinal() > 0L ? EnumConstantsMentorSimNao.SIM.getValueInt() : EnumConstantsMentorSimNao.NAO.getValueInt()));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("movimentaEstoque", (Object)ToolMethods.isNulThen((Number)params.getMovimentaEstoque(), (Integer)2));
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        if (!ToolMethods.isAffirmative((Number)params.getMovimentaEstoque())) {
            q.setParameter("cancelado", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            rz.setDescricao("Ped. Comercio: / ID. Cliente: " + String.valueOf(h.get("ID_PEDIDO_COMERCIO")) + " - " + String.valueOf(h.get("ID_CLIENTE")));
            rz.setEntradaSaida((short)1);
            rz.setMovimentacaoFisica((Short)h.get("MOVIMENTACAO_FISICA"));
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setValorUnitario(0.0);
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getTicketFiscal(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "SELECT g.quantidade         AS QUANTIDADE, gc.identificador     AS ID_GRADE_COR, c.nome               AS GRADE_COR, p.identificador      AS ID_PRODUTO, p.nome               AS NOME_PRODUTO, p.codigoAuxiliar     AS COD_AUXILIAR, u.sigla              AS UNIDADE_MEDIDA, 1                    AS ENTRADA_SAIDA, 0                    AS VALOR_CUSTO, e.nome               AS ESPECIE, s.nome               AS SUB_ESPECIE, g.dataMovimentacao     AS DATA_MOVIMENTO, l.loteFabricacao     AS LOTE_FABRICACAO, cl.identificador     AS ID_CLIENTE, pe.nome              AS NOME_CLIENTE, t.serie              AS SERIE, t.numero             AS NUMERO_NOTA, ce.identificador     AS ID_CENTRO_ESTOQUE, ce.descricao         AS CENTRO_ESTOQUE FROM GradeItemTicketFiscal          g INNER JOIN g.gradeCor               gc INNER JOIN gc.cor                   c INNER JOIN gc.produtoGrade         pg left JOIN g.ticketFiscal           t left JOIN pg.produto                p left JOIN p.unidadeMedida          u left JOIN p.especie                e left JOIN p.subEspecie             s left JOIN g.loteFabricacao         l left JOIN g.centroEstoque         ce left JOIN t.unidadeFatCliente     uc left JOIN uc.cliente              cl left JOIN cl.pessoa               pe WHERE (:filtrarProduto    <> 1 OR p.identificador      BETWEEN :idInicial           AND :idFinal) AND   (:filtrarEspecie    <> 1 OR e.identificador      BETWEEN :idEspecieInicial    AND :idEspecieFinal) AND   (:filtrarSubespecie <> 1 OR s.identificador      BETWEEN :idSubespecieInicial AND :idSubespecieFinal) AND   (:filtrarGradeCor   <> 1 OR gc.identificador     BETWEEN :idGradeCorInicial   AND :idGradeCorFinal) AND   (                           cast(g.dataMovimentacao as date)     BETWEEN :dataIn              AND :dataFim) AND   (                           g.empresa            =       :empresa) AND   (:filtrarLote       <> 1 OR l.identificador      =       :idLote) AND   (:filtrarCentro     <> 1 OR ce.identificador     BETWEEN :idCentroInicial     AND :idCentroFinal) AND   (:movimentaEstoque  =  2 OR g.movimentacaoFisica = :movimentaEstoque)";
        if (!ToolMethods.isAffirmative((Number)params.getMovimentaEstoque())) {
            hql = (String)hql + " AND (t.status != :cancelado) ";
        }
        hql = (String)hql + " ORDER BY p.identificador,          g.dataMovimentacao";
        Query q = this.query((String)hql);
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("empresa", (Object)params.getEmpresa());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("movimentaEstoque", (Object)ToolMethods.isNulThen((Number)params.getMovimentaEstoque(), (Integer)2));
        if (!ToolMethods.isAffirmative((Number)params.getMovimentaEstoque())) {
            q.setParameter("cancelado", (Object)EnumConstTicketFiscalStatus.CANCELADO.value);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            if (ToolMethods.isAffirmative((Number)params.getExibirNomeClienteForne())) {
                rz.setDescricao("Ticket Saida: " + String.valueOf(h.get("SERIE")) + "/" + String.valueOf(h.get("NUMERO_NOTA")) + " - " + String.valueOf(h.get("ID_CLIENTE")) + " - " + String.valueOf(h.get("NOME_CLIENTE")));
            } else {
                rz.setDescricao("Ticket Saida: " + String.valueOf(h.get("SERIE")) + "/" + String.valueOf(h.get("NUMERO_NOTA")) + " - " + String.valueOf(h.get("ID_CLIENTE")));
            }
            rz.setEntradaSaida((short)1);
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            rz.setMovimentacaoFisica((Short)h.get("MOVIMENTACAO_FISICA"));
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getTicketFiscalEntrada(ServiceMovimentoProdutosImpl.Params params) {
        String hql = "SELECT t.pesoLiquidoBalanca AS QUANTIDADE, gc.identificador     AS ID_GRADE_COR, c.nome               AS GRADE_COR, p.identificador      AS ID_PRODUTO, p.nome               AS NOME_PRODUTO, p.codigoAuxiliar     AS COD_AUXILIAR, u.sigla              AS UNIDADE_MEDIDA, 0                    AS ENTRADA_SAIDA, t.valorPrecoMedio    AS VALOR_CUSTO, e.nome               AS ESPECIE, s.nome               AS SUB_ESPECIE, t.dataTicket         AS DATA_MOVIMENTO, l.loteFabricacao     AS LOTE_FABRICACAO, cl.identificador     AS ID_FORNECEDOR, pe.nome              AS NOME_FORNECEDOR, 0                    AS SERIE, t.numero             AS NUMERO_NOTA, ce.identificador     AS ID_CENTRO_ESTOQUE, ce.descricao         AS CENTRO_ESTOQUE, t.movimentarEstoque  AS MOVIMENTACAO_FISICA FROM TicketFiscalTerceiros          t INNER JOIN t.gradeCor              gc INNER JOIN gc.cor                   c INNER JOIN gc.produtoGrade          pg INNER JOIN pg.produto                p INNER JOIN p.unidadeMedida          u INNER JOIN p.especie                e INNER JOIN p.subEspecie             s INNER JOIN t.loteFabricacao         l INNER JOIN t.centroEstoque         ce left JOIN t.unidadeFatFornecedor  uc left JOIN uc.fornecedor           cl left JOIN cl.pessoa               pe WHERE (:filtrarProduto    <> 1 OR p.identificador      BETWEEN :idInicial           AND :idFinal) AND   (:filtrarEspecie    <> 1 OR e.identificador      BETWEEN :idEspecieInicial    AND :idEspecieFinal) AND   (:filtrarSubespecie <> 1 OR s.identificador      BETWEEN :idSubespecieInicial AND :idSubespecieFinal) AND   (:filtrarGradeCor   <> 1 OR gc.identificador     BETWEEN :idGradeCorInicial   AND :idGradeCorFinal) AND   (                           cast(t.dataTicket as date)     BETWEEN :dataIn              AND :dataFim) AND   (                           t.empresa            =       :empresa) AND   (:filtrarLote       <> 1 OR l.identificador      =       :idLote) AND   (:filtrarCentro     <> 1 OR ce.identificador     BETWEEN :idCentroInicial     AND :idCentroFinal) AND   (:movimentaEstoque  =  2 OR t.movimentarEstoque  =  :movimentaEstoque ) AND   t.status = 1 ORDER BY p.identificador,          t.dataTicket";
        Query q = this.query(hql);
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("empresa", (Object)params.getEmpresa());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("movimentaEstoque", (Object)ToolMethods.isNulThen((Number)params.getMovimentaEstoque(), (Integer)2));
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            if (ToolMethods.isAffirmative((Number)params.getExibirNomeClienteForne())) {
                rz.setDescricao("Ticket Entrada: " + String.valueOf(h.get("NUMERO_NOTA")) + " - " + String.valueOf(h.get("ID_FORNECEDOR")) + " - " + String.valueOf(h.get("NOME_FORNECEDOR")));
            } else {
                rz.setDescricao("Ticket Entrada: " + String.valueOf(h.get("NUMERO_NOTA")) + " - " + String.valueOf(h.get("ID_FORNECEDOR")));
            }
            rz.setEntradaSaida((short)0);
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            rz.setMovimentacaoFisica((Short)h.get("MOVIMENTACAO_FISICA"));
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            rz.setValorUnitario((Double)h.get("VALOR_CUSTO"));
            toRet.add(rz);
        }
        return toRet;
    }

    public Collection getMovimentosNFCe(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select (cast(i.quantidadeComercial as double)) as QUANTIDADE, gc.identificador as ID_GRADE_COR, cc.nome as GRADE_COR, i.movimentacaoFisica as MOVIMENTACAO_FISICA, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, pr.codigoAuxiliar as COD_AUXILIAR, unid.sigla as UNIDADE_MEDIDA, 1 AS ENTRADA_SAIDA, i.valorUnitarioComercial AS VALOR_CUSTO, i.dataEmissao as DATA_MOVIMENTO,  lt.loteFabricacao as LOTE_FABRICACAO, np.serie as SERIE,np.numero as NUMERO_NOTA, cli.identificador as ID_CLIENTE, pesCli.nome as NOME_CLIENTE, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE, cons.nome as CONSUMIDOR  from NFCeItem i left join i.gradeCor gc left join gc.cor cc left join gc.produtoGrade pg left join pg.produto pr left join pr.especie esp left join pr.subEspecie sub left join pr.unidadeMedida unid left join i.nfce np left join np.unidadeFatCliente unC left join unC.cliente cli left join cli.pessoa pesCli left join np.nfCeConsumidor cons left join np.naturezaOperacao nat left join i.loteFabricacao lt left join i.centroEstoque ce where      (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and (:filtrarGradeCor <> 1 or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and i.dataEmissao between :dataIn and :dataFim and i.empresa=:empresa and (:filtrarLote <> 1 or lt.identificador = :idLote)  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal) and (:movimentaEstoque = 2 or i.movimentacaoFisica = :movimentaEstoque) ";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        hql = (String)hql + " order by pr.identificador, i.dataEmissao";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("movimentaEstoque", (Object)ToolMethods.isNulThen((Number)params.getMovimentaEstoque(), (Integer)2));
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("filtrarCentro", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarCentroEstoque(), Integer.class));
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            if (ToolMethods.isAffirmative((Number)params.getExibirNomeClienteForne())) {
                rz.setDescricao("NFC-e: " + String.valueOf(h.get("SERIE")) + "/" + String.valueOf(h.get("NUMERO_NOTA")) + this.getIdCliente(h) + this.getNomeCliente(h));
            } else {
                rz.setDescricao("NFC-e: " + String.valueOf(h.get("SERIE")) + "/" + String.valueOf(h.get("NUMERO_NOTA")) + this.getIdCliente(h));
            }
            rz.setEntradaSaida((short)1);
            rz.setValorUnitario((Double)h.get("VALOR_CUSTO"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            rz.setMovimentacaoFisica((Short)h.get("MOVIMENTACAO_FISICA"));
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            toRet.add(rz);
        }
        return toRet;
    }

    private String getIdCliente(HashMap h) {
        if (h.get("ID_CLIENTE") != null) {
            return " - " + String.valueOf(h.get("ID_CLIENTE"));
        }
        return "";
    }

    private String getNomeCliente(HashMap h) {
        if (h.get("NOME_CLIENTE") != null && !((String)h.get("NOME_CLIENTE")).isEmpty()) {
            return " - " + String.valueOf(h.get("NOME_CLIENTE"));
        }
        if (h.get("CONSUMIDOR") != null && !((String)h.get("CONSUMIDOR")).isEmpty()) {
            return " - CONSUMIDOR: " + String.valueOf(h.get("CONSUMIDOR"));
        }
        return "";
    }

    public Collection getMovimentosPedidoPreVenda(ServiceMovimentoProdutosImpl.Params params) {
        Object hql = "select gci.quantidade as QUANTIDADE, gc.identificador as ID_GRADE_COR, c.nome as GRADE_COR, gci.movimentacaoFisica as MOVIMENTACAO_FISICA, pr.identificador as ID_PRODUTO, pr.nome as NOME_PRODUTO, pr.codigoAuxiliar as COD_AUXILIAR, un.sigla as UNIDADE_MEDIDA, 1 AS ENTRADA_SAIDA, 0 AS VALOR_CUSTO, esp.nome as ESPECIE, sub.nome as SUB_ESPECIE, gci.dataMovimentacao as DATA_MOVIMENTO,  l.loteFabricacao as LOTE_FABRICACAO, cl.identificador as ID_CLIENTE, p.identificador as ID_PEDIDO, ce.identificador as ID_CENTRO_ESTOQUE, ce.descricao as CENTRO_ESTOQUE,  pesCli.nome as NOME_CLIENTE  from GradeItemPedido gci  inner join gci.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto pr left join gci.itemPedido i left join pr.unidadeMedida un left join pr.especie esp left join pr.subEspecie sub left join i.pedido p left join gci.centroEstoque ce left join gci.loteFabricacao l left join p.unidadeFatCliente unfat left join unfat.cliente cl  left join cl.pessoa pesCli  where (:filtrarProduto <> 1 or pr.identificador between :idInicial and :idFinal) and (:filtrarEspecie <> 1 or esp.identificador between :idEspecieInicial and :idEspecieFinal) and (:filtrarSubespecie <> 1 or sub.identificador between :idSubespecieInicial and :idSubespecieFinal) and cast(gci.dataMovimentacao as date) between :dataIn and :dataFim and (:filtrarGradeCor <> 1 or gc.identificador between :idGradeCorInicial and :idGradeCorFinal) and gci.empresa=:empresa and (:filtrarLote <> 1 or l.identificador = :idLote)  and gci.quantidade > 0  and (:filtrarCentro <> 1 or ce.identificador between :idCentroInicial and :idCentroFinal)  and (:movimentaEstoque = 2 or gci.movimentacaoFisica = :movimentaEstoque) ";
        if (params.getTipoCentroEstoque() != 9) {
            hql = (String)hql + " and ce.tipoEstProprioTerceiros = :tipoCentroEstoque";
        }
        hql = (String)hql + " order by pr.identificador, gci.dataMovimentacao";
        Query q = this.query((String)hql);
        q.setParameter("dataIn", (Object)params.getDataInicial());
        q.setParameter("dataFim", (Object)params.getDataFinal());
        q.setParameter("filtrarProduto", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarProduto(), Integer.class));
        q.setParameter("idInicial", (Object)params.getIdInicial());
        q.setParameter("idFinal", (Object)params.getIdFinal());
        q.setParameter("filtrarLote", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarLote(), Integer.class));
        q.setParameter("idGradeCorInicial", (Object)params.getIdGradeCorInicial());
        q.setParameter("idGradeCorFinal", (Object)params.getIdGradeCorFinal());
        q.setParameter("filtrarGradeCor", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarGradeCor(), Integer.class));
        q.setParameter("filtrarEspecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarEspecie(), Integer.class));
        q.setParameter("idEspecieInicial", (Object)params.getIdEspecieInicial());
        q.setParameter("idEspecieFinal", (Object)params.getIdEspecieFinal());
        q.setParameter("filtrarSubespecie", (Object)ToolMethods.isNulThen0((Number)params.getFiltrarSubespecieProduto(), Integer.class));
        q.setParameter("idSubespecieInicial", (Object)params.getIdSubespecieInicial());
        q.setParameter("idSubespecieFinal", (Object)params.getIdSubespecieFinal());
        q.setParameter("idCentroInicial", (Object)params.getIdCentroEstInicial());
        q.setParameter("idCentroFinal", (Object)params.getIdCentroEstFinal());
        q.setParameter("filtrarCentro", (Object)(params.getIdCentroEstInicial() != null && params.getIdCentroEstFinal() > 0L ? EnumConstantsMentorSimNao.SIM.getValueInt() : EnumConstantsMentorSimNao.NAO.getValueInt()));
        q.setParameter("idLote", (Object)params.getIdLote());
        q.setParameter("movimentaEstoque", (Object)ToolMethods.isNulThen((Number)params.getMovimentaEstoque(), (Integer)2));
        q.setParameter("empresa", (Object)params.getEmpresa());
        if (params.getTipoCentroEstoque() != 9) {
            q.setParameter("tipoCentroEstoque", (Object)params.getTipoCentroEstoque());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        ArrayList<RazaoAnalitico> toRet = new ArrayList<RazaoAnalitico>();
        for (HashMap h : r) {
            RazaoAnalitico rz = new RazaoAnalitico();
            if (ToolMethods.isAffirmative((Number)params.getExibirNomeClienteForne())) {
                rz.setDescricao("Pedido: " + String.valueOf(h.get("ID_PEDIDO")) + this.getIdCliente(h) + this.getNomeCliente(h));
            } else {
                rz.setDescricao("Pedido: " + String.valueOf(h.get("ID_PEDIDO")) + this.getIdCliente(h));
            }
            rz.setEntradaSaida((short)1);
            rz.setMovimentacaoFisica((Short)h.get("MOVIMENTACAO_FISICA"));
            rz.setIdProduto((Long)h.get("ID_PRODUTO"));
            rz.setLoteFabricacao((String)h.get("LOTE_FABRICACAO"));
            rz.setNomeProduto((String)h.get("NOME_PRODUTO"));
            rz.setQuantidade(ToolFormatter.arrredondarNumero((Double)((Double)h.get("QUANTIDADE")), (int)6));
            rz.setValorUnitario(0.0);
            rz.setEspecie((String)h.get("ESPECIE"));
            rz.setSubEspecie((String)h.get("SUB_ESPECIE"));
            rz.setIdGradeCor((Long)h.get("ID_GRADE_COR"));
            rz.setGradeCor((String)h.get("GRADE_COR"));
            rz.setDataMovimento((Date)h.get("DATA_MOVIMENTO"));
            rz.setUnidadeMedida((String)h.get("UNIDADE_MEDIDA"));
            rz.setCodAux((String)h.get("COD_AUXILIAR"));
            rz.setIdCentroEstoque((Long)h.get("ID_CENTRO_ESTOQUE"));
            rz.setCentroEstoque((String)h.get("CENTRO_ESTOQUE"));
            toRet.add(rz);
        }
        return toRet;
    }
}

