/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstAtualizacaoStatus;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.InformacoesTecnicasCliente;
import com.touchcomp.basementor.model.vo.LogAtualizacaoVersaoCli;
import com.touchcomp.basementor.model.vo.ServidorCliente;
import com.touchcomp.basementor.model.vo.TipoBDVersao;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.VersaoMentor;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLogAtualizacaoVersaoCliImpl
extends DaoGenericEntityImpl<LogAtualizacaoVersaoCli, Long> {
    public LogAtualizacaoVersaoCli getLog(ServidorCliente serv, VersaoMentor versao, TipoBDVersao tp) {
        return (LogAtualizacaoVersaoCli)this.toUnique(this.restrictions(this.eq("servidorCliente", serv), this.eq("versaoMentor", versao), this.eq("tipoBDVersao", tp)));
    }

    public LogAtualizacaoVersaoCli findUltimoLogAtualizacaoByIdCliente(Long idCliente) {
        Criteria c = this.criteria();
        c.createAlias("servidorCliente", "s");
        c.createAlias("s.informacoesTecnicaCliente", "i");
        c.createAlias("i.clienteContSistemas", "c");
        c.createAlias("versaoMentor", "v");
        c.setMaxResults(1);
        c.addOrder(Order.desc((String)"v.codigo"));
        return (LogAtualizacaoVersaoCli)this.toUnique(this.restrictions(c, this.eq("c.identificador", idCliente)));
    }

    public List<LogAtualizacaoVersaoCli> getLogsAguardandoRevisao() {
        return this.toList(this.restrictions(this.eq("tipoRevisao", EnumConstAtualizacaoStatus.ATUALIZACAO_AGUARDA_REVISAO.getValue())));
    }

    public List<LogAtualizacaoVersaoCli> getLogs(InformacoesTecnicasCliente inf) {
        Criteria c = this.criteria();
        c.createAlias("servidorCliente", "s");
        c.createAlias("versaoMentor", "v");
        c.addOrder(Order.desc((String)"v.codigo"));
        return this.toList(this.restrictions(c, this.eq("s.informacoesTecnicaCliente", inf)));
    }

    public LogAtualizacaoVersaoCli getUltimaAtualizacao(ClienteContSistemas cliente) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jServ = builder.join("servidorCliente");
        Join jServInfo = builder.join((From)jServ, "informacoesTecnicaCliente");
        builder.equal((From)jServInfo, "clienteContSistemas", cliente);
        builder.orderDesc("codigoVersao");
        builder.setMaxResults(1);
        return (LogAtualizacaoVersaoCli)builder.getUniqueResult();
    }

    public LogAtualizacaoVersaoCli getUltimaAtualizacao(UsuarioBasico usuarioCliente) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jServ = builder.join("servidorCliente");
        Join jServInfo = builder.join((From)jServ, "informacoesTecnicaCliente");
        Join jClienteContSist = builder.join((From)jServInfo, "clienteContSistemas");
        Join jEmpresa = builder.join((From)jClienteContSist, "empresa");
        builder.equal((From)jEmpresa, "pessoa", usuarioCliente.getPessoa());
        builder.orderDesc("codigoVersao");
        builder.setMaxResults(1);
        return (LogAtualizacaoVersaoCli)builder.getUniqueResult();
    }
}

