/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Lancamento;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoLoteContabilImpl
extends DaoGenericEntityImpl<LoteContabil, Long> {
    public List<LoteContabil> getLotesInconsistentes(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        String query = "select distinct l  from LoteContabil l where l.grupoEmpresa = :grupoEmpresa and l.dataLote between :dataInicial and :dataFinal and l.totalCreditos <> l.totalDebitos";
        Query q = this.query(query);
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public LoteContabil getLoteByNumero(Long numeroLote, GrupoEmpresa grupoEmpresa) {
        return (LoteContabil)this.toUnique(this.restrictions(this.eq("numeroLote", numeroLote), this.eq("grupoEmpresa", grupoEmpresa)));
    }

    public void deleteLoteQuery(LoteContabil item) {
        if (item != null) {
            CriteriaBuilder criteriaBuilder = this.getSession().getCriteriaBuilder();
            CriteriaDelete query = criteriaBuilder.createCriteriaDelete(Lancamento.class);
            Root root = query.from(Lancamento.class);
            query.where((Expression)criteriaBuilder.equal((Expression)root.get("loteContabil"), (Object)item));
            this.getSession().createQuery(query).executeUpdate();
            CriteriaDelete queryLote = criteriaBuilder.createCriteriaDelete(LoteContabil.class);
            Root rootLote = queryLote.from(LoteContabil.class);
            queryLote.where((Expression)criteriaBuilder.equal((Expression)rootLote.get("identificador"), (Object)item.getIdentificador()));
            this.getSession().createQuery(queryLote).executeUpdate();
        }
    }

    public List<LoteContabil> getLotesByIntervaloNumero(Long numeroLoteInicial, Long numeroLoteFinal) {
        return this.toList(this.restrictions(this.between("numeroLote", numeroLoteInicial, numeroLoteFinal)));
    }

    public List<LoteContabil> getLotesByIntervaloDatas(Date dataInicial, Date dataFinal) {
        return this.toList(this.restrictions(this.between("dataLote", dataInicial, dataFinal)));
    }
}

